/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.feature;

import com.icatchtek.pancam.core.feature.ICatchGLDefaultStreamParam;
import com.icatchtek.pancam.core.feature.gles.ICatchPancamGL;
import com.icatchtek.pancam.core.feature.stream.ICatchStreamControl;
import com.icatchtek.pancam.core.feature.stream.ICatchStreamProvider;
import com.icatchtek.pancam.core.feature.stream.ICatchStreamPublish;
import com.icatchtek.pancam.core.feature.stream.ICatchStreamStablization;
import com.icatchtek.pancam.core.feature.utils.AppFeatureUtils;
import com.icatchtek.pancam.core.jni.JPancamPreview;
import com.icatchtek.pancam.core.jni.extractor.DataTypeUtil;
import com.icatchtek.pancam.core.jni.extractor.PartialFrameInfo;
import com.icatchtek.pancam.customer.ICatchIPancamPreview;
import com.icatchtek.pancam.customer.gl.ICatchIPancamGL;
import com.icatchtek.pancam.customer.stream.ICatchIStreamControl;
import com.icatchtek.pancam.customer.stream.ICatchIStreamProvider;
import com.icatchtek.pancam.customer.stream.ICatchIStreamPublish;
import com.icatchtek.pancam.customer.stream.ICatchIStreamStablization;
import com.icatchtek.pancam.customer.surface.ICatchISurfaceContext;
import com.icatchtek.reliant.customer.exception.IchBufferTooSmallException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchNotSupportedException;
import com.icatchtek.reliant.customer.exception.IchPermissionDeniedException;
import com.icatchtek.reliant.customer.exception.IchStreamAlreadyStartedException;
import com.icatchtek.reliant.customer.exception.IchStreamNotRunningException;
import com.icatchtek.reliant.customer.exception.IchStreamNotSupportException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.exception.IchVideoStreamClosedException;
import com.icatchtek.reliant.customer.transport.ICatchINETTransport;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCBulkTransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCIsoTransport;
import com.icatchtek.reliant.customer.transport.ICatchUsbScsiTransport;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;
import com.icatchtek.reliant.customer.type.ICatchStreamParam;

public final class ICatchPancamPreview
extends AppFeatureUtils
implements ICatchIPancamPreview {
    private int sessionID;
    private ICatchITransport transport;
    private ICatchStreamControl streamControl;
    private ICatchStreamPublish streamPublish;
    private ICatchStreamStablization streamStablization;

    public ICatchPancamPreview(int sessionID, ICatchITransport transport) {
        this.sessionID = sessionID;
        this.transport = transport;
        try {
            int streamControlID = JPancamPreview.getStreamControl_Jni(sessionID);
            if (streamControlID >= 0) {
                this.streamControl = new ICatchStreamControl(streamControlID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            int streamPublishID = JPancamPreview.getStreamPublish_Jni(sessionID);
            if (streamPublishID >= 0) {
                this.streamPublish = new ICatchStreamPublish(streamPublishID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            int streamStablizationID = JPancamPreview.getStreamStablization_Jni(sessionID);
            if (streamStablizationID >= 0) {
                this.streamStablization = new ICatchStreamStablization(streamStablizationID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void releaseResource() {
        if (this.pancamGL != null) {
            this.pancamGL.releaseResource();
        }
        if (this.streamControl != null) {
            this.streamControl.releaseResource();
        }
        if (this.streamPublish != null) {
            this.streamPublish.releaseResource();
        }
        if (this.streamProvider != null) {
            this.streamProvider.releaseResource();
        }
        if (this.streamStablization != null) {
            this.streamStablization.releaseResource();
        }
    }

    @Override
    public boolean enableRender(ICatchISurfaceContext surfaceContext) throws IchInvalidSessionException, IchPermissionDeniedException, IchInvalidArgumentException {
        this.__reset_gl_feature();
        this.__reset_provider_feature();
        return JPancamPreview.enableRender_Jni(this.sessionID, surfaceContext.getSurfaceID());
    }

    @Override
    public ICatchIPancamGL enableGLRender() throws IchInvalidSessionException, IchPermissionDeniedException {
        return this.enableGLRender(1);
    }

    @Override
    public ICatchIPancamGL enableGLRender(int panoramaType) throws IchInvalidSessionException, IchPermissionDeniedException {
        int glID = JPancamPreview.enableGLRender_Jni(this.sessionID, panoramaType);
        if (glID < 0) {
            return null;
        }
        this.__reset_provider_feature();
        this.pancamGL = new ICatchPancamGL(glID);
        return this.pancamGL;
    }

    @Override
    public ICatchIStreamProvider disableRender() throws IchInvalidSessionException, IchPermissionDeniedException {
        int streamProviderID = JPancamPreview.disableRender_Jni(this.sessionID);
        if (streamProviderID < 0) {
            return null;
        }
        this.__reset_gl_feature();
        this.streamProvider = new ICatchStreamProvider(streamProviderID);
        return this.streamProvider;
    }

    @Override
    public boolean start(ICatchStreamParam streamParam) throws IchStreamNotSupportException, IchInvalidSessionException, IchInvalidArgumentException, IchTransportException, IchStreamAlreadyStartedException {
        return this.start(streamParam, false);
    }

    @Override
    public boolean start(ICatchStreamParam streamParam, boolean enableAudio) throws IchStreamNotSupportException, IchInvalidSessionException, IchInvalidArgumentException, IchTransportException, IchStreamAlreadyStartedException {
        return this.start(streamParam, enableAudio, 0);
    }

    @Override
    public boolean start(ICatchStreamParam streamParam, boolean enableAudio, int outputFPS) throws IchStreamNotSupportException, IchInvalidSessionException, IchInvalidArgumentException, IchTransportException, IchStreamAlreadyStartedException {
        return this.start(streamParam, enableAudio, outputFPS, true, true);
    }

    @Override
    public boolean start(ICatchStreamParam streamParam, boolean enableAudio, int outputFPS, boolean convertVideo, boolean convertAudio) throws IchStreamNotSupportException, IchInvalidSessionException, IchInvalidArgumentException, IchTransportException, IchStreamAlreadyStartedException {
        if (streamParam == null) {
            throw new IchInvalidArgumentException("streamParam should not be null");
        }
        ICatchGLDefaultStreamParam streamParamA = null;
        if (this.transport instanceof ICatchINETTransport) {
            streamParamA = new ICatchGLDefaultStreamParam(2, streamParam.toString(), 554);
        }
        if (this.transport instanceof ICatchUVCIsoTransport || this.transport instanceof ICatchUVCBulkTransport || this.transport instanceof ICatchUsbScsiTransport) {
            streamParamA = new ICatchGLDefaultStreamParam(1, streamParam.toString(), 0);
        }
        if (streamParamA == null) {
            throw new IchStreamNotSupportException("The SDK does not accept transport: " + this.transport);
        }
        return JPancamPreview.start_Jni(this.sessionID, ((Object)streamParamA).toString(), enableAudio, outputFPS, convertVideo, convertAudio);
    }

    @Override
    public boolean stop() throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        return JPancamPreview.stop_Jni(this.sessionID);
    }

    @Override
    public boolean getThumbnail(ICatchFrameBuffer frameBuffer, int timeoutInMS) throws IchVideoStreamClosedException, IchStreamNotRunningException, IchTryAgainException, IchInvalidSessionException, IchBufferTooSmallException {
        return this.getThumbnail(0, frameBuffer, timeoutInMS);
    }

    @Override
    public boolean getThumbnail(int streamNo, ICatchFrameBuffer frameBuffer, int timeoutInMS) throws IchVideoStreamClosedException, IchStreamNotRunningException, IchTryAgainException, IchInvalidSessionException, IchBufferTooSmallException {
        String partialFrameInfoStr = JPancamPreview.getThumbnail_Jni(this.sessionID, streamNo, frameBuffer.getBuffer(), timeoutInMS);
        PartialFrameInfo frameInfo = DataTypeUtil.toPartialFrameInfo(partialFrameInfoStr);
        if (frameInfo == null || frameInfo.getFrameSize() <= 0) {
            return false;
        }
        frameBuffer.setFrameSize(frameInfo.getFrameSize());
        frameBuffer.setPresentationTime(frameInfo.getPresentationTime());
        return true;
    }

    @Override
    public boolean stop(int nextOps) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        if (!(this.transport instanceof ICatchUsbScsiTransport)) {
            throw new IchTransportException("Operation not supported, the next Ops only available in usb scsi mode");
        }
        return JPancamPreview.stop_Jni(this.sessionID, nextOps);
    }

    @Override
    public boolean isStreamingOn() throws IchInvalidSessionException, IchTransportException {
        return JPancamPreview.isStreamingOn_Jni(this.sessionID);
    }

    @Override
    public ICatchIStreamControl getStreamControl() throws IchStreamNotRunningException, IchNotSupportedException {
        if (this.streamControl == null) {
            throw new IchStreamNotRunningException("Streaming not running.");
        }
        return this.streamControl;
    }

    @Override
    public ICatchIStreamPublish getStreamPublish() throws IchStreamNotRunningException, IchNotSupportedException {
        if (this.streamPublish == null) {
            throw new IchStreamNotRunningException("Streaming not running.");
        }
        return this.streamPublish;
    }

    @Override
    public ICatchIStreamStablization getStreamStablization() throws IchStreamNotRunningException, IchNotSupportedException {
        if (this.streamStablization == null) {
            throw new IchStreamNotRunningException("Streaming not running.");
        }
        return this.streamStablization;
    }
}

