/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.feature;

import com.icatchtek.pancam.core.feature.gles.ICatchPancamGL;
import com.icatchtek.pancam.core.feature.stream.ICatchStreamControl;
import com.icatchtek.pancam.core.feature.stream.ICatchStreamProvider;
import com.icatchtek.pancam.core.feature.stream.ICatchStreamPublish;
import com.icatchtek.pancam.core.feature.stream.ICatchStreamStablization;
import com.icatchtek.pancam.core.feature.utils.AppFeatureUtils;
import com.icatchtek.pancam.core.jni.JPancamVideoPlayback;
import com.icatchtek.pancam.core.jni.extractor.DataTypeUtil;
import com.icatchtek.pancam.core.jni.extractor.PartialFrameInfo;
import com.icatchtek.pancam.core.util.type.NativeFile;
import com.icatchtek.pancam.customer.ICatchIPancamVideoPlayback;
import com.icatchtek.pancam.customer.gl.ICatchIPancamGL;
import com.icatchtek.pancam.customer.stream.ICatchIStreamControl;
import com.icatchtek.pancam.customer.stream.ICatchIStreamProvider;
import com.icatchtek.pancam.customer.stream.ICatchIStreamStablization;
import com.icatchtek.pancam.customer.surface.ICatchISurfaceContext;
import com.icatchtek.reliant.customer.exception.IchBufferTooSmallException;
import com.icatchtek.reliant.customer.exception.IchFileNotFoundException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchNotSupportedException;
import com.icatchtek.reliant.customer.exception.IchPauseFailedException;
import com.icatchtek.reliant.customer.exception.IchPermissionDeniedException;
import com.icatchtek.reliant.customer.exception.IchResumeFailedException;
import com.icatchtek.reliant.customer.exception.IchSeekFailedException;
import com.icatchtek.reliant.customer.exception.IchStreamAlreadyStartedException;
import com.icatchtek.reliant.customer.exception.IchStreamNotRunningException;
import com.icatchtek.reliant.customer.exception.IchStreamNotSupportException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.exception.IchVideoStreamClosedException;
import com.icatchtek.reliant.customer.transport.ICatchINETTransport;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import com.icatchtek.reliant.customer.type.ICatchFile;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;

public final class ICatchPancamVideoPlayback
extends AppFeatureUtils
implements ICatchIPancamVideoPlayback {
    private int sessionID;
    private ICatchITransport transport;
    private ICatchStreamControl streamControl;
    private ICatchStreamPublish streamPublish;
    private ICatchStreamStablization streamStablization;

    public ICatchPancamVideoPlayback(int sessionID, ICatchITransport transport) {
        this.sessionID = sessionID;
        this.transport = transport;
        try {
            int streamControlID = JPancamVideoPlayback.getStreamControl_Jni(sessionID);
            if (streamControlID >= 0) {
                this.streamControl = new ICatchStreamControl(streamControlID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            int streamPublishID = JPancamVideoPlayback.getStreamPublish_Jni(sessionID);
            if (streamPublishID >= 0) {
                this.streamPublish = new ICatchStreamPublish(streamPublishID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            int streamStablizationID = JPancamVideoPlayback.getStreamStablization_Jni(sessionID);
            if (streamStablizationID >= 0) {
                this.streamStablization = new ICatchStreamStablization(streamStablizationID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void releaseResource() {
        if (this.pancamGL != null) {
            this.pancamGL.releaseResource();
        }
        if (this.streamControl != null) {
            this.streamControl.releaseResource();
        }
        if (this.streamPublish != null) {
            this.streamPublish.releaseResource();
        }
        if (this.streamProvider != null) {
            this.streamProvider.releaseResource();
        }
        if (this.streamStablization != null) {
            this.streamStablization.releaseResource();
        }
    }

    @Override
    public boolean enableRender(ICatchISurfaceContext surfaceContext) throws IchInvalidSessionException, IchInvalidArgumentException, IchPermissionDeniedException {
        this.__reset_gl_feature();
        this.__reset_provider_feature();
        return JPancamVideoPlayback.enableRender_Jni(this.sessionID, surfaceContext.getSurfaceID());
    }

    @Override
    public ICatchIPancamGL enableGLRender() throws IchInvalidSessionException, IchPermissionDeniedException {
        return this.enableGLRender(1);
    }

    @Override
    public ICatchIPancamGL enableGLRender(int panoramaType) throws IchInvalidSessionException, IchPermissionDeniedException {
        int glID = JPancamVideoPlayback.enableGLRender_Jni(this.sessionID, panoramaType);
        if (glID < 0) {
            return null;
        }
        this.__reset_provider_feature();
        this.pancamGL = new ICatchPancamGL(glID);
        return this.pancamGL;
    }

    @Override
    public ICatchIStreamProvider disableRender() throws IchInvalidSessionException, IchPermissionDeniedException {
        int streamProviderID = JPancamVideoPlayback.disableRender_Jni(this.sessionID);
        if (streamProviderID < 0) {
            return null;
        }
        this.__reset_gl_feature();
        this.streamProvider = new ICatchStreamProvider(streamProviderID);
        return this.streamProvider;
    }

    @Override
    public boolean play(ICatchFile file, boolean disableAudio, boolean remote) throws IchStreamNotSupportException, IchStreamAlreadyStartedException, IchInvalidSessionException, IchTransportException, IchFileNotFoundException, IchInvalidArgumentException {
        if (!(this.transport instanceof ICatchINETTransport) && remote) {
            throw new IchStreamNotSupportException("Play file on camera does not support this transport: " + this.transport);
        }
        String fileString = NativeFile.toICatchFile(file);
        return JPancamVideoPlayback.play_Jni(this.sessionID, fileString, 5.0, disableAudio, remote);
    }

    @Override
    public boolean play(ICatchFile file, boolean disableAudio, boolean remote, double cacheingTime) throws IchStreamNotSupportException, IchStreamAlreadyStartedException, IchInvalidSessionException, IchTransportException, IchFileNotFoundException, IchInvalidArgumentException {
        if (!(this.transport instanceof ICatchINETTransport) && remote) {
            throw new IchStreamNotSupportException("Play file on camera does not support this transport: " + this.transport);
        }
        String fileString = NativeFile.toICatchFile(file);
        return JPancamVideoPlayback.play_Jni(this.sessionID, fileString, cacheingTime, disableAudio, remote);
    }

    @Override
    public boolean stop() throws IchStreamNotRunningException, IchInvalidSessionException, IchTransportException {
        return JPancamVideoPlayback.stop_Jni(this.sessionID);
    }

    @Override
    public boolean getThumbnail(ICatchFrameBuffer frameBuffer, int timeoutInMS) throws IchVideoStreamClosedException, IchStreamNotRunningException, IchTryAgainException, IchInvalidSessionException, IchBufferTooSmallException {
        return this.getThumbnail(0, frameBuffer, timeoutInMS);
    }

    @Override
    public boolean getThumbnail(int streamNo, ICatchFrameBuffer frameBuffer, int timeoutInMS) throws IchVideoStreamClosedException, IchStreamNotRunningException, IchTryAgainException, IchInvalidSessionException, IchBufferTooSmallException {
        String partialFrameInfoStr = JPancamVideoPlayback.getThumbnail_Jni(this.sessionID, streamNo, frameBuffer.getBuffer(), timeoutInMS);
        PartialFrameInfo frameInfo = DataTypeUtil.toPartialFrameInfo(partialFrameInfoStr);
        if (frameInfo == null || frameInfo.getFrameSize() <= 0) {
            return false;
        }
        frameBuffer.setFrameSize(frameInfo.getFrameSize());
        frameBuffer.setPresentationTime(frameInfo.getPresentationTime());
        return true;
    }

    @Override
    public boolean isStreamingOn() throws IchInvalidSessionException, IchTransportException {
        return JPancamVideoPlayback.isStreamingOn_Jni(this.sessionID);
    }

    @Override
    public double getLength() throws IchStreamNotRunningException, IchTransportException, IchInvalidSessionException {
        return JPancamVideoPlayback.getLength_Jni(this.sessionID);
    }

    @Override
    public boolean pause() throws IchTransportException, IchInvalidSessionException, IchStreamNotRunningException, IchPauseFailedException {
        boolean retVal = JPancamVideoPlayback.pause_Jni(this.sessionID);
        return retVal;
    }

    @Override
    public boolean resume() throws IchStreamNotRunningException, IchTransportException, IchInvalidSessionException, IchResumeFailedException {
        boolean retVal = JPancamVideoPlayback.resume_Jni(this.sessionID);
        return retVal;
    }

    @Override
    public boolean seek(double pts) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchSeekFailedException {
        boolean retVal = JPancamVideoPlayback.seek_Jni(this.sessionID, pts);
        return retVal;
    }

    @Override
    public ICatchIStreamControl getStreamControl() throws IchStreamNotRunningException, IchNotSupportedException {
        if (this.streamControl == null) {
            throw new IchStreamNotRunningException("Streaming not running.");
        }
        return this.streamControl;
    }

    @Override
    public ICatchIStreamStablization getStreamStablization() throws IchStreamNotRunningException, IchNotSupportedException {
        if (this.streamStablization == null) {
            throw new IchStreamNotRunningException("Streaming not running.");
        }
        return this.streamStablization;
    }
}

