/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.feature.gles;

import com.icatchtek.pancam.core.feature.gles.ICatchPancamGLTransform;
import com.icatchtek.pancam.core.jni.JPancamGL;
import com.icatchtek.pancam.core.jni.JPancamGLTransform;
import com.icatchtek.pancam.customer.exception.IchGLAlreadyInitedException;
import com.icatchtek.pancam.customer.exception.IchGLFormatNotSupportedException;
import com.icatchtek.pancam.customer.exception.IchGLNotInitedException;
import com.icatchtek.pancam.customer.exception.IchGLPanoramaTypeNotSupportedException;
import com.icatchtek.pancam.customer.exception.IchGLSurfaceAlreadySetException;
import com.icatchtek.pancam.customer.exception.IchGLSurfaceNotSetException;
import com.icatchtek.pancam.customer.gl.ICatchIPancamGL;
import com.icatchtek.pancam.customer.gl.ICatchIPancamGLTransform;
import com.icatchtek.pancam.customer.surface.ICatchISurfaceContext;
import com.icatchtek.reliant.customer.exception.IchDeprecatedException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;

public class ICatchPancamGL
implements ICatchIPancamGL {
    private boolean deprecated = false;
    private int pancamGLID;
    private ICatchPancamGLTransform pancamGLTransform;

    public ICatchPancamGL(int pancamGLID) {
        this.pancamGLID = pancamGLID;
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.releaseResource();
    }

    public void releaseResource() {
        JPancamGL.removeGL_Jni(this.pancamGLID);
        JPancamGLTransform.removeGLTransform_Jni(this.pancamGLID);
    }

    @Override
    public ICatchIPancamGLTransform getPancamGLTransform() throws IchDeprecatedException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        if (this.pancamGLTransform != null) {
            return this.pancamGLTransform;
        }
        int glTransportID = JPancamGL.getPancamGLTransport_Jni(this.pancamGLID);
        if (glTransportID >= 0) {
            this.pancamGLTransform = new ICatchPancamGLTransform(glTransportID);
        }
        return this.pancamGLTransform;
    }

    @Override
    public boolean init() throws IchDeprecatedException, IchGLAlreadyInitedException, IchGLPanoramaTypeNotSupportedException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        return JPancamGL.init_Jni(this.pancamGLID);
    }

    @Override
    public boolean init(int panoramaType) throws IchDeprecatedException, IchGLAlreadyInitedException, IchGLPanoramaTypeNotSupportedException {
        return this.init();
    }

    @Override
    public boolean release() throws IchDeprecatedException, IchGLNotInitedException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        return JPancamGL.release_Jni(this.pancamGLID);
    }

    @Override
    public boolean changePanoramaType(int panoramaType) throws IchGLPanoramaTypeNotSupportedException, IchGLNotInitedException, IchInvalidArgumentException {
        return JPancamGL.changePanoramaType_Jni(this.pancamGLID, panoramaType);
    }

    @Override
    public boolean setSurface(int surfaceType, ICatchISurfaceContext surfaceContext) throws IchDeprecatedException, IchGLNotInitedException, IchGLSurfaceAlreadySetException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        return JPancamGL.setSurface_Jni(this.pancamGLID, surfaceType, surfaceContext.getSurfaceID());
    }

    @Override
    public boolean removeSurface(int surfaceType, ICatchISurfaceContext surfaceContext) throws IchDeprecatedException, IchGLNotInitedException, IchGLSurfaceNotSetException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        return JPancamGL.removeSurface_Jni(this.pancamGLID, surfaceType, surfaceContext.getSurfaceID());
    }

    @Override
    public boolean setFormat(int format, int width, int height) throws IchGLNotInitedException, IchGLFormatNotSupportedException, IchDeprecatedException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        if (format == 130) {
            format = 149;
        }
        return JPancamGL.setFormat_Jni(this.pancamGLID, format, width, height);
    }

    @Override
    public boolean clearFormat() throws IchDeprecatedException, IchGLNotInitedException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        return JPancamGL.clearFormat_Jni(this.pancamGLID);
    }
}

