/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.feature.gles;

import com.icatchtek.pancam.core.jni.JPancamGLTransform;
import com.icatchtek.pancam.customer.gl.ICatchIPancamGLTransform;
import com.icatchtek.pancam.customer.type.ICatchGLPoint;
import com.icatchtek.reliant.customer.exception.IchDeprecatedException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;

public class ICatchPancamGLTransform
implements ICatchIPancamGLTransform {
    private boolean deprecated = false;
    private int glTransformID;

    protected ICatchPancamGLTransform(int glTransformID) {
        this.glTransformID = glTransformID;
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        JPancamGLTransform.removeGLTransform_Jni(this.glTransformID);
    }

    @Override
    public boolean reset() throws IchDeprecatedException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        return JPancamGLTransform.reset_Jni(this.glTransformID);
    }

    @Override
    public boolean locate(float distance) throws IchDeprecatedException, IchInvalidArgumentException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        return JPancamGLTransform.locate_Jni(this.glTransformID, distance);
    }

    @Override
    public boolean scale(float factor) throws IchDeprecatedException, IchInvalidArgumentException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        return JPancamGLTransform.scale_Jni(this.glTransformID, factor);
    }

    @Override
    public boolean scale(float factor, float distance) throws IchDeprecatedException, IchInvalidArgumentException {
        return this.scale(factor);
    }

    @Override
    public boolean rotate(ICatchGLPoint startPoint, ICatchGLPoint endPoint) throws IchDeprecatedException, IchInvalidArgumentException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        return JPancamGLTransform.rotate_Jni(this.glTransformID, startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY());
    }

    @Override
    public boolean rotate(int rotation, float speedX, float speedY, float speedZ, long timestamp) throws IchDeprecatedException, IchInvalidArgumentException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        switch (rotation) {
            case 0: {
                return JPancamGLTransform.rotate_Jni(this.glTransformID, 0, speedX, speedY, speedZ, timestamp);
            }
            case 1: {
                return JPancamGLTransform.rotate_Jni(this.glTransformID, 1, speedX, speedY, speedZ, timestamp);
            }
            case 2: {
                return JPancamGLTransform.rotate_Jni(this.glTransformID, 2, speedX, speedY, speedZ, timestamp);
            }
            case 3: {
                return JPancamGLTransform.rotate_Jni(this.glTransformID, 3, speedX, speedY, speedZ, timestamp);
            }
        }
        throw new IchInvalidArgumentException("The rotation not supported now, the degree should matches landscape or portrait.");
    }

    @Override
    public boolean updateGyro(float speedX, float speedY, float speedZ, long timestamp) throws IchDeprecatedException, IchInvalidArgumentException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        return JPancamGLTransform.updateGyro_Jni(this.glTransformID, speedX, speedY, speedZ, timestamp);
    }

    @Override
    public boolean updateAccel(float speedX, float speedY, float speedZ, long timestamp) throws IchDeprecatedException, IchInvalidArgumentException {
        if (this.deprecated) {
            throw new IchDeprecatedException("The deprecated instance, please get new one.");
        }
        return JPancamGLTransform.updateAccel_Jni(this.glTransformID, speedX, speedY, speedZ, timestamp);
    }
}

