/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.feature.stream;

import com.icatchtek.pancam.core.jni.JStreamControl;
import com.icatchtek.pancam.customer.stream.ICatchIStreamControl;
import com.icatchtek.reliant.customer.exception.IchAudioAlreadyDisabledException;
import com.icatchtek.reliant.customer.exception.IchAudioAlreadyEnabledException;
import com.icatchtek.reliant.customer.exception.IchImageSizeNotSpecifiedException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchMuxerAlreadyStartedException;
import com.icatchtek.reliant.customer.exception.IchMuxerNotStartedException;
import com.icatchtek.reliant.customer.exception.IchMuxerStartFailedException;
import com.icatchtek.reliant.customer.exception.IchNotSupportedException;
import com.icatchtek.reliant.customer.exception.IchStreamNotRunningException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;
import com.icatchtek.reliant.customer.type.ICatchImageSize;
import java.util.List;

public class ICatchStreamControl
implements ICatchIStreamControl {
    private int streamControlID;

    public ICatchStreamControl(int streamControlID) {
        this.streamControlID = streamControlID;
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        JStreamControl.removeStreamControl_Jni(this.streamControlID);
    }

    public void releaseResource() {
        JStreamControl.removeStreamControl_Jni(this.streamControlID);
    }

    @Override
    public boolean enableAudio() throws IchInvalidSessionException, IchAudioAlreadyEnabledException, IchTransportException, IchNotSupportedException {
        return JStreamControl.enableAudio_Jni(this.streamControlID);
    }

    @Override
    public boolean disableAudio() throws IchInvalidSessionException, IchAudioAlreadyDisabledException, IchTransportException, IchNotSupportedException {
        return JStreamControl.disableAudio_Jni(this.streamControlID);
    }

    @Override
    public boolean startMovieRecord(String fileName, boolean remote) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchMuxerAlreadyStartedException, IchMuxerStartFailedException {
        return this.startMovieRecord(fileName, remote, false);
    }

    @Override
    public boolean startMovieRecord(String fileName, boolean remote, boolean tag360) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchMuxerAlreadyStartedException, IchMuxerStartFailedException {
        return JStreamControl.startMovieRecord_Jni(this.streamControlID, fileName, remote, tag360);
    }

    @Override
    public boolean stopMovieRecord() throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchMuxerNotStartedException {
        return JStreamControl.stopMovieRecord_Jni(this.streamControlID);
    }

    @Override
    public boolean addMovieRecordInfo(String info) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchMuxerNotStartedException {
        return JStreamControl.addMovieRecordInfo_Jni(this.streamControlID, info);
    }

    @Override
    public List<ICatchImageSize> getSupportedImageSize() throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchNotSupportedException {
        return JStreamControl.getSupportedImageSizes_Jni(this.streamControlID);
    }

    @Override
    public boolean setImageSize(ICatchImageSize imageSize) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchInvalidArgumentException, IchNotSupportedException {
        return JStreamControl.setImageSize_Jni(this.streamControlID, imageSize);
    }

    @Override
    public boolean snapImage(ICatchFrameBuffer image, int timeoutInMS) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchImageSizeNotSpecifiedException, IchNotSupportedException {
        return JStreamControl.snapImage_Jni(this.streamControlID, image, true, timeoutInMS);
    }

    @Override
    public boolean snapImage(ICatchFrameBuffer image, boolean stitched, int timeoutInMS) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchImageSizeNotSpecifiedException, IchNotSupportedException {
        return JStreamControl.snapImage_Jni(this.streamControlID, image, stitched, timeoutInMS);
    }
}

