/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.feature.stream;

import com.icatchtek.pancam.core.jni.JStreamProvider;
import com.icatchtek.pancam.core.jni.extractor.DataTypeUtil;
import com.icatchtek.pancam.core.jni.extractor.PartialFrameInfo;
import com.icatchtek.pancam.customer.stream.ICatchIStreamProvider;
import com.icatchtek.reliant.customer.exception.IchAudioStreamClosedException;
import com.icatchtek.reliant.customer.exception.IchBufferTooSmallException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchPbStreamPausedException;
import com.icatchtek.reliant.customer.exception.IchStreamNotRunningException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.exception.IchVideoStreamClosedException;
import com.icatchtek.reliant.customer.type.ICatchAudioFormat;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;
import java.util.List;

public class ICatchStreamProvider
implements ICatchIStreamProvider {
    private int streamProviderID;

    public ICatchStreamProvider(int streamProviderID) {
        this.streamProviderID = streamProviderID;
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        JStreamProvider.removeStreamProvider_Jni(this.streamProviderID);
    }

    public void releaseResource() {
        JStreamProvider.removeStreamProvider_Jni(this.streamProviderID);
    }

    @Override
    public boolean containsVideoStream() throws IchTransportException, IchInvalidSessionException, IchStreamNotRunningException {
        return JStreamProvider.containsVideoStream_Jni(this.streamProviderID);
    }

    @Override
    public boolean containsAudioStream() throws IchTransportException, IchInvalidSessionException, IchStreamNotRunningException {
        return JStreamProvider.containsAudioStream_Jni(this.streamProviderID);
    }

    @Override
    public ICatchVideoFormat getVideoFormat() throws IchInvalidSessionException, IchStreamNotRunningException, IchTransportException {
        return JStreamProvider.getVideoFormat_Jni(this.streamProviderID, 0);
    }

    @Override
    public List<ICatchVideoFormat> getVideoFormats() throws IchInvalidSessionException, IchStreamNotRunningException, IchTransportException {
        return JStreamProvider.getVideoFormats_Jni(this.streamProviderID);
    }

    @Override
    public ICatchAudioFormat getAudioFormat() throws IchInvalidSessionException, IchStreamNotRunningException, IchTransportException {
        return JStreamProvider.getAudioFormat_Jni(this.streamProviderID, 0);
    }

    @Override
    public List<ICatchAudioFormat> getAudioFormats() throws IchInvalidSessionException, IchStreamNotRunningException, IchTransportException {
        return JStreamProvider.getAudioFormats_Jni(this.streamProviderID);
    }

    @Override
    public boolean getNextVideoFrame(ICatchFrameBuffer frameBuffer) throws IchTransportException, IchVideoStreamClosedException, IchStreamNotRunningException, IchTryAgainException, IchInvalidSessionException, IchBufferTooSmallException, IchPbStreamPausedException {
        return this.getNextVideoFrame(0, frameBuffer);
    }

    @Override
    public boolean getNextVideoFrame(int streamNo, ICatchFrameBuffer frameBuffer) throws IchTransportException, IchVideoStreamClosedException, IchStreamNotRunningException, IchTryAgainException, IchInvalidSessionException, IchBufferTooSmallException, IchPbStreamPausedException {
        String partialFrameInfoStr = JStreamProvider.getNextVideoFrame_Jni(this.streamProviderID, streamNo, frameBuffer.getBuffer());
        PartialFrameInfo frameInfo = DataTypeUtil.toPartialFrameInfo(partialFrameInfoStr);
        if (frameInfo == null || frameInfo.getFrameSize() <= 0) {
            return false;
        }
        frameBuffer.setFrameSize(frameInfo.getFrameSize());
        frameBuffer.setPresentationTime(frameInfo.getPresentationTime());
        return true;
    }

    @Override
    public boolean getNextAudioFrame(ICatchFrameBuffer frameBuffer) throws IchTransportException, IchAudioStreamClosedException, IchStreamNotRunningException, IchTryAgainException, IchInvalidSessionException, IchBufferTooSmallException, IchPbStreamPausedException {
        return this.getNextAudioFrame(0, frameBuffer);
    }

    @Override
    public boolean getNextAudioFrame(int streamNo, ICatchFrameBuffer frameBuffer) throws IchTransportException, IchAudioStreamClosedException, IchStreamNotRunningException, IchTryAgainException, IchInvalidSessionException, IchBufferTooSmallException, IchPbStreamPausedException {
        String partialFrameInfoStr = JStreamProvider.getNextAudioFrame_Jni(this.streamProviderID, streamNo, frameBuffer.getBuffer());
        PartialFrameInfo frameInfo = DataTypeUtil.toPartialFrameInfo(partialFrameInfoStr);
        if (frameInfo == null || frameInfo.getFrameSize() <= 0) {
            return false;
        }
        frameBuffer.setFrameSize(frameInfo.getFrameSize());
        frameBuffer.setPresentationTime(frameInfo.getPresentationTime());
        return true;
    }
}

