/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.feature.type;

import com.icatchtek.reliant.customer.type.ICatchAudioFormat;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class VrGLStreamSettings {
    public static final String PAN_MINE_CODE_PCM = "audio/raw";
    public static final String PAN_MINE_CODE_RGBA = "video/raw";
    public static final String PAN_MINE_CODE_I420 = "video/raw";
    public static final String PAN_MINE_CODE_H264 = "video/avc";
    public static final String PAN_MINE_CODE_HEVC = "video/hevc";
    public static final String PAN_MINE_CODE_JPEG = "video/jpeg";
    private ICatchAudioFormat audioFormat;
    private ICatchVideoFormat videoFormat;

    public static String getMineType(int codec) {
        switch (codec) {
            case 64: {
                return PAN_MINE_CODE_JPEG;
            }
            case 41: {
                return PAN_MINE_CODE_H264;
            }
            case 149: {
                return "video/raw";
            }
            case 150: {
                return "video/raw";
            }
            case 144: {
                return PAN_MINE_CODE_PCM;
            }
            case 49: {
                return PAN_MINE_CODE_HEVC;
            }
        }
        return null;
    }

    public VrGLStreamSettings() {
        this.audioFormat = new ICatchAudioFormat(144, 44100, 2, 16);
        this.videoFormat = new ICatchVideoFormat(41, 1920, 1080, 30);
    }

    public VrGLStreamSettings(ICatchAudioFormat audioFormat, ICatchVideoFormat videoFormat) {
        this.audioFormat = audioFormat;
        this.videoFormat = videoFormat;
    }

    public ICatchAudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public void setAudioFormat(ICatchAudioFormat audioFormat) {
        this.audioFormat = audioFormat;
    }

    public ICatchVideoFormat getVideoFormat() {
        return this.videoFormat;
    }

    public void setVideoFormat(ICatchVideoFormat videoFormat) {
        this.videoFormat = videoFormat;
    }

    public String toString() {
        try {
            JSONObject attributes = new JSONObject();
            attributes.put("audio", (Object)this.audioFormat.toString());
            attributes.put("video", (Object)this.videoFormat.toString());
            return attributes.toString();
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static VrGLStreamSettings fromString(String attributes) {
        try {
            JSONObject jsonObject = new JSONObject(attributes);
            ICatchVideoFormat videoFormat = ICatchVideoFormat.fromString((String)jsonObject.getString("video"));
            ICatchAudioFormat audioFormat = ICatchAudioFormat.fromString((String)jsonObject.getString("audio"));
            return new VrGLStreamSettings(audioFormat, videoFormat);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

