/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.jni;

import com.icatchtek.pancam.core.jni.NativeLibraryLoader;
import com.icatchtek.pancam.core.jni.extractor.NativeValueExtractor;
import com.icatchtek.reliant.customer.exception.IchBufferTooSmallException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchPermissionDeniedException;
import com.icatchtek.reliant.customer.exception.IchStreamNotRunningException;
import com.icatchtek.reliant.customer.exception.IchStreamNotSupportException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.exception.IchVideoStreamClosedException;

public class JPancamPreview {
    public static boolean enableRender_Jni(int sessionID, int surfaceID) throws IchInvalidSessionException, IchInvalidArgumentException, IchPermissionDeniedException {
        String content = JPancamPreview.enableRender(sessionID, surfaceID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchInvalidArgumentException ex) {
            throw ex;
        }
        catch (IchPermissionDeniedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int enableGLRender_Jni(int sessionID, int panoramaType) throws IchInvalidSessionException, IchPermissionDeniedException {
        String content = JPancamPreview.enableGLRender(sessionID, panoramaType);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchPermissionDeniedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int disableRender_Jni(int sessionID) throws IchInvalidSessionException, IchPermissionDeniedException {
        String content = JPancamPreview.disableRender(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchPermissionDeniedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean setPreviewParam_Jni(int sessionID, int cachingTime, boolean swDecode) {
        String content = JPancamPreview.setPreviewParam(sessionID, cachingTime, swDecode);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean start_Jni(int sessionID, String parameter, boolean enableAudio, int outputFPS, boolean convertVideo, boolean convertAudio) throws IchInvalidSessionException, IchTransportException, IchInvalidArgumentException, IchStreamNotSupportException {
        String content = JPancamPreview.start(sessionID, parameter, enableAudio, outputFPS, convertVideo, convertAudio);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchInvalidArgumentException ex) {
            throw ex;
        }
        catch (IchStreamNotSupportException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean stop_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String content = JPancamPreview.stop(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getThumbnail_Jni(int sessionID, int streamNo, byte[] buffer, int timeoutInMS) throws IchInvalidSessionException, IchBufferTooSmallException, IchTryAgainException, IchStreamNotRunningException, IchVideoStreamClosedException {
        String content = JPancamPreview.getThumbnail(sessionID, streamNo, buffer, timeoutInMS);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchTryAgainException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchBufferTooSmallException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (IchVideoStreamClosedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean stop_Jni(int sessionID, int nextOps) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String content = JPancamPreview.stopScsiStream(sessionID, nextOps);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean isStreamingOn_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException {
        String content = JPancamPreview.isStreamingOn(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getStreamControl_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String content = JPancamPreview.getStreamControl(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int getStreamPublish_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String content = JPancamPreview.getStreamPublish(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int getStreamStablization_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String content = JPancamPreview.getStreamStablization(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    private static native String enableRender(int var0, int var1);

    private static native String enableGLRender(int var0, int var1);

    private static native String disableRender(int var0);

    private static native String setPreviewParam(int var0, int var1, boolean var2);

    private static native String start(int var0, String var1, boolean var2, int var3, boolean var4, boolean var5);

    private static native String stop(int var0);

    private static native String stopScsiStream(int var0, int var1);

    private static native String getThumbnail(int var0, int var1, byte[] var2, int var3);

    private static native String isStreamingOn(int var0);

    private static native String getStreamControl(int var0);

    private static native String getStreamPublish(int var0);

    private static native String getStreamStablization(int var0);

    static {
        NativeLibraryLoader.loadLibrary();
    }
}

