/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.jni;

import com.icatchtek.pancam.core.jni.NativeLibraryLoader;
import com.icatchtek.pancam.core.jni.extractor.NativeValueExtractor;
import com.icatchtek.pancam.core.util.VrLogger;
import com.icatchtek.reliant.customer.exception.IchBufferTooSmallException;
import com.icatchtek.reliant.customer.exception.IchFileNotFoundException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchPauseFailedException;
import com.icatchtek.reliant.customer.exception.IchPermissionDeniedException;
import com.icatchtek.reliant.customer.exception.IchResumeFailedException;
import com.icatchtek.reliant.customer.exception.IchSeekFailedException;
import com.icatchtek.reliant.customer.exception.IchStreamNotRunningException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.exception.IchVideoStreamClosedException;

public class JPancamVideoPlayback {
    public static boolean enableRender_Jni(int sessionID, int surfaceID) throws IchInvalidSessionException, IchInvalidArgumentException, IchPermissionDeniedException {
        String content = JPancamVideoPlayback.enableRender(sessionID, surfaceID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchInvalidArgumentException ex) {
            throw ex;
        }
        catch (IchPermissionDeniedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int enableGLRender_Jni(int sessionID, int panoramaType) throws IchInvalidSessionException, IchPermissionDeniedException {
        String content = JPancamVideoPlayback.enableGLRender(sessionID, panoramaType);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchPermissionDeniedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int disableRender_Jni(int sessionID) throws IchInvalidSessionException, IchPermissionDeniedException {
        String content = JPancamVideoPlayback.disableRender(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchPermissionDeniedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean play_Jni(int sessionID, String file, double cachingTime, boolean disableAudio, boolean remote) throws IchInvalidSessionException, IchTransportException, IchFileNotFoundException {
        String content = JPancamVideoPlayback.play(sessionID, file, cachingTime, disableAudio, remote);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchFileNotFoundException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean stop_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException {
        String content = JPancamVideoPlayback.stop(sessionID);
        VrLogger.logI("video_pb", "after jni stop, return str: " + content);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getThumbnail_Jni(int sessionID, int streamNo, byte[] buffer, int timeoutInMS) throws IchInvalidSessionException, IchBufferTooSmallException, IchTryAgainException, IchStreamNotRunningException, IchVideoStreamClosedException {
        String content = JPancamVideoPlayback.getThumbnail(sessionID, streamNo, buffer, timeoutInMS);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchTryAgainException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchBufferTooSmallException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (IchVideoStreamClosedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean isStreamingOn_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException {
        String content = JPancamVideoPlayback.isStreamingOn(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static double getLength_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String content = JPancamVideoPlayback.getLength(sessionID);
        try {
            return NativeValueExtractor.extractNativeDoubleValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1.0;
        }
    }

    public static boolean pause_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException, IchPauseFailedException, IchStreamNotRunningException {
        String content = JPancamVideoPlayback.pause(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchPauseFailedException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean resume_Jni(int sessionID) throws IchInvalidSessionException, IchResumeFailedException, IchTransportException, IchStreamNotRunningException {
        String content = JPancamVideoPlayback.resume(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchResumeFailedException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean seek_Jni(int sessionID, double timeInSecs) throws IchInvalidSessionException, IchTransportException, IchSeekFailedException, IchStreamNotRunningException {
        String content = JPancamVideoPlayback.seek(sessionID, timeInSecs);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchSeekFailedException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getStreamControl_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String content = JPancamVideoPlayback.getStreamControl(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int getStreamPublish_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String content = JPancamVideoPlayback.getStreamPublish(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int getStreamStablization_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String content = JPancamVideoPlayback.getStreamStablization(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    private static native String enableRender(int var0, int var1);

    private static native String enableGLRender(int var0, int var1);

    private static native String disableRender(int var0);

    private static native String play(int var0, String var1, double var2, boolean var4, boolean var5);

    private static native String stop(int var0);

    private static native String getThumbnail(int var0, int var1, byte[] var2, int var3);

    private static native String isStreamingOn(int var0);

    private static native String getLength(int var0);

    private static native String pause(int var0);

    private static native String resume(int var0);

    private static native String seek(int var0, double var1);

    private static native String getStreamControl(int var0);

    private static native String getStreamPublish(int var0);

    private static native String getStreamStablization(int var0);

    static {
        NativeLibraryLoader.loadLibrary();
    }
}

