/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.jni;

import com.icatchtek.pancam.core.jni.NativeLibraryLoader;
import com.icatchtek.pancam.core.jni.extractor.DataTypeUtil;
import com.icatchtek.pancam.core.jni.extractor.NativeValueExtractor;
import com.icatchtek.reliant.customer.exception.IchImageSizeNotSpecifiedException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchMuxerAlreadyStartedException;
import com.icatchtek.reliant.customer.exception.IchMuxerNotStartedException;
import com.icatchtek.reliant.customer.exception.IchMuxerStartFailedException;
import com.icatchtek.reliant.customer.exception.IchNotSupportedException;
import com.icatchtek.reliant.customer.exception.IchStreamNotRunningException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;
import com.icatchtek.reliant.customer.type.ICatchImageSize;
import java.util.List;

public class JStreamControl {
    public static boolean removeStreamControl_Jni(int sessionID) {
        String content = JStreamControl.removeStreamControl(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean startMovieRecord_Jni(int sessionID, String fileName, boolean remote, boolean tag360) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchMuxerAlreadyStartedException, IchMuxerStartFailedException {
        String content = JStreamControl.startMovieRecord(sessionID, fileName, remote, tag360);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (IchMuxerStartFailedException ex) {
            throw ex;
        }
        catch (IchMuxerAlreadyStartedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean stopMovieRecord_Jni(int sessionID) throws IchTransportException, IchStreamNotRunningException, IchMuxerNotStartedException {
        String content = JStreamControl.stopMovieRecord(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (IchMuxerNotStartedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean addMovieRecordInfo_Jni(int sessionID, String info) throws IchTransportException, IchStreamNotRunningException, IchMuxerNotStartedException {
        String content = JStreamControl.addMovieRecordInfo(sessionID, info);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (IchMuxerNotStartedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean enableAudio_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException {
        String content = JStreamControl.enableAudio(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean disableAudio_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException {
        String content = JStreamControl.disableAudio(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static List<ICatchImageSize> getSupportedImageSizes_Jni(int sessionID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchNotSupportedException {
        String content = JStreamControl.getSupportedImageSizes(sessionID);
        try {
            String imageSizeStr = NativeValueExtractor.extractNativeStringValue(content);
            return DataTypeUtil.toImageSizes(imageSizeStr);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (IchNotSupportedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean setImageSize_Jni(int sessionID, ICatchImageSize imageSize) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchInvalidArgumentException, IchNotSupportedException {
        String content = JStreamControl.setImageSize(sessionID, imageSize.getImageW(), imageSize.getImageH());
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (IchInvalidArgumentException ex) {
            throw ex;
        }
        catch (IchNotSupportedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean snapImage_Jni(int sessionID, ICatchFrameBuffer frameBuffer, boolean stitched, int timeoutInMS) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException, IchImageSizeNotSpecifiedException, IchNotSupportedException {
        String content = JStreamControl.snapImage(sessionID, frameBuffer.getBuffer(), stitched, timeoutInMS);
        try {
            int dataSize = NativeValueExtractor.extractNativeIntValue(content);
            if (dataSize <= 0) {
                return false;
            }
            frameBuffer.setFrameSize(dataSize);
            return true;
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (IchImageSizeNotSpecifiedException ex) {
            throw ex;
        }
        catch (IchNotSupportedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static native String removeStreamControl(int var0);

    private static native String startMovieRecord(int var0, String var1, boolean var2, boolean var3);

    private static native String stopMovieRecord(int var0);

    private static native String addMovieRecordInfo(int var0, String var1);

    private static native String getSupportedImageSizes(int var0);

    private static native String setImageSize(int var0, int var1, int var2);

    private static native String snapImage(int var0, byte[] var1, boolean var2, int var3);

    private static native String enableAudio(int var0);

    private static native String disableAudio(int var0);

    static {
        NativeLibraryLoader.loadLibrary();
    }
}

