/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.jni;

import com.icatchtek.pancam.core.jni.NativeLibraryLoader;
import com.icatchtek.pancam.core.jni.extractor.DataTypeUtil;
import com.icatchtek.pancam.core.jni.extractor.NativeValueExtractor;
import com.icatchtek.pancam.core.util.VrLogger;
import com.icatchtek.reliant.customer.exception.IchAudioStreamClosedException;
import com.icatchtek.reliant.customer.exception.IchBufferTooSmallException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchStreamNotRunningException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.exception.IchVideoStreamClosedException;
import com.icatchtek.reliant.customer.type.ICatchAudioFormat;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;
import java.util.LinkedList;
import java.util.List;

public class JStreamProvider {
    public static boolean removeStreamProvider_Jni(int streamProviderID) {
        String content = JStreamProvider.removeStreamProvider(streamProviderID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean containsVideoStream_Jni(int streamProviderID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String content = JStreamProvider.containsVideoStream(streamProviderID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean containsAudioStream_Jni(int streamProviderID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String content = JStreamProvider.containsAudioStream(streamProviderID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static ICatchAudioFormat getAudioFormat_Jni(int streamProviderID, int streamNo) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String formatRetStr = JStreamProvider.getAudioFormat(streamProviderID, streamNo);
        try {
            String formatStr = NativeValueExtractor.extractNativeStringValue(formatRetStr);
            ICatchAudioFormat audioFormat = DataTypeUtil.toPartialAudioFormat(formatStr);
            if (audioFormat == null) {
                return null;
            }
            return audioFormat;
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static List<ICatchAudioFormat> getAudioFormats_Jni(int streamProviderID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String formatRetStr = JStreamProvider.getAudioFormat(streamProviderID, 0);
        try {
            String formatStr = NativeValueExtractor.extractNativeStringValue(formatRetStr);
            ICatchAudioFormat audioFormat = DataTypeUtil.toPartialAudioFormat(formatStr);
            if (audioFormat == null) {
                return null;
            }
            LinkedList<ICatchAudioFormat> audioFormats = new LinkedList<ICatchAudioFormat>();
            audioFormats.add(audioFormat);
            return audioFormats;
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static boolean __fill_video_csd_info(int streamProviderID, int streamNo, ICatchVideoFormat videoFormat) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        byte[] csd0 = new byte[255];
        byte[] csd1 = new byte[255];
        String csd0RetStr = JStreamProvider.getVideoFormatCsdA(streamProviderID, streamNo, csd0);
        String csd1RetStr = JStreamProvider.getVideoFormatCsdB(streamProviderID, streamNo, csd1);
        try {
            int csd1DataSize;
            int csd0DataSize = NativeValueExtractor.extractNativeIntValue(csd0RetStr);
            if (csd0DataSize > 0) {
                videoFormat.setCsd_0(csd0, csd0DataSize);
            }
            if ((csd1DataSize = NativeValueExtractor.extractNativeIntValue(csd1RetStr)) > 0) {
                videoFormat.setCsd_1(csd1, csd1DataSize);
            }
            return true;
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static List<ICatchVideoFormat> getVideoFormats_Jni(int streamProviderID) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        String formatRetStr = JStreamProvider.getVideoFormats(streamProviderID);
        try {
            String formatsStr = NativeValueExtractor.extractNativeStringValue(formatRetStr);
            String[] formatsStrArray = formatsStr.split("##");
            LinkedList<ICatchVideoFormat> videoFormats = new LinkedList<ICatchVideoFormat>();
            for (String formatStr : formatsStrArray) {
                ICatchVideoFormat videoFormat = DataTypeUtil.toPartialVideoFormat(formatStr);
                if (videoFormat == null) {
                    return null;
                }
                if (!JStreamProvider.__fill_video_csd_info(streamProviderID, videoFormat.getStreamNo(), videoFormat)) {
                    return null;
                }
                videoFormats.add(videoFormat);
            }
            return videoFormats;
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ICatchVideoFormat getVideoFormat_Jni(int streamProviderID, int streamNo) throws IchInvalidSessionException, IchTransportException, IchStreamNotRunningException {
        VrLogger.logI("__flow_debug__", "getVideoFormat 1.");
        String formatRetStr = JStreamProvider.getVideoFormat(streamProviderID, streamNo);
        VrLogger.logI("__flow_debug__", "getVideoFormat 1." + formatRetStr);
        try {
            String formatStr = NativeValueExtractor.extractNativeStringValue(formatRetStr);
            VrLogger.logI("__flow_debug__", "getVideoFormat extract." + formatStr);
            ICatchVideoFormat videoFormat = DataTypeUtil.toPartialVideoFormat(formatStr);
            VrLogger.logI("__flow_debug__", "getVideoFormat extract." + videoFormat);
            if (videoFormat == null) {
                return null;
            }
            if (!JStreamProvider.__fill_video_csd_info(streamProviderID, streamNo, videoFormat)) {
                return null;
            }
            return videoFormat;
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getNextVideoFrame_Jni(int streamProviderID, int streamNo, byte[] buffer) throws IchInvalidSessionException, IchTransportException, IchBufferTooSmallException, IchTryAgainException, IchStreamNotRunningException, IchVideoStreamClosedException {
        String content = JStreamProvider.getNextVideoFrame(streamProviderID, streamNo, buffer);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchTryAgainException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchBufferTooSmallException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (IchVideoStreamClosedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getNextAudioFrame_Jni(int streamProviderID, int streamNo, byte[] buffer) throws IchInvalidSessionException, IchTransportException, IchBufferTooSmallException, IchTryAgainException, IchStreamNotRunningException, IchAudioStreamClosedException {
        String content = JStreamProvider.getNextAudioFrame(streamProviderID, streamNo, buffer);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchTransportException ex) {
            throw ex;
        }
        catch (IchTryAgainException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchBufferTooSmallException ex) {
            throw ex;
        }
        catch (IchStreamNotRunningException ex) {
            throw ex;
        }
        catch (IchAudioStreamClosedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static native String removeStreamProvider(int var0);

    private static native String containsVideoStream(int var0);

    private static native String containsAudioStream(int var0);

    private static native String getAudioFormat(int var0, int var1);

    private static native String getVideoFormat(int var0, int var1);

    private static native String getVideoFormats(int var0);

    private static native String getVideoFormatCsdA(int var0, int var1, byte[] var2);

    private static native String getVideoFormatCsdB(int var0, int var1, byte[] var2);

    private static native String getNextVideoFrame(int var0, int var1, byte[] var2);

    private static native String getNextAudioFrame(int var0, int var1, byte[] var2);

    static {
        NativeLibraryLoader.loadLibrary();
    }
}

