/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.jni.extractor;

import com.icatchtek.pancam.core.jni.extractor.PartialFrameInfo;
import com.icatchtek.pancam.core.util.VrLogger;
import com.icatchtek.pancam.customer.type.ICatchGLStablizationInfo;
import com.icatchtek.reliant.customer.type.ICatchAudioFormat;
import com.icatchtek.reliant.customer.type.ICatchImageSize;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;
import java.util.LinkedList;
import java.util.List;

public class DataTypeUtil {
    public static List<Integer> splitStringToIntList(String value) {
        if (value == null) {
            return new LinkedList<Integer>();
        }
        String[] intValStrs = value.split(";");
        LinkedList<Integer> intVals = new LinkedList<Integer>();
        for (String intValStr : intValStrs) {
            intVals.add(Integer.parseInt(intValStr));
        }
        return intVals;
    }

    public static List<ICatchVideoFormat> splitStringToVideoFormatList(String value) {
        String[] videoFormatValStrs;
        if (value == null) {
            return new LinkedList<ICatchVideoFormat>();
        }
        LinkedList<ICatchVideoFormat> videoFormats = new LinkedList<ICatchVideoFormat>();
        for (String videoFormatValStr : videoFormatValStrs = value.split(";")) {
            ICatchVideoFormat videoFormat = DataTypeUtil.toVideoFormat(videoFormatValStr);
            if (videoFormat == null) continue;
            videoFormats.add(videoFormat);
        }
        return videoFormats;
    }

    public static List<String> splitStringToStringList(String value) {
        if (value == null) {
            return new LinkedList<String>();
        }
        String[] strValStrs = value.split(";");
        LinkedList<String> stringVals = new LinkedList<String>();
        for (String stringVal : strValStrs) {
            stringVals.add(stringVal);
        }
        return stringVals;
    }

    public static PartialFrameInfo toPartialFrameInfo(String value) {
        String[] strValStrs;
        if (value == null) {
            return null;
        }
        int codec = 0;
        int frameSize = 0;
        double presentationTime = 0.0;
        for (String strVal : strValStrs = value.split(";")) {
            String[] keyVal = strVal.split("=");
            if (keyVal.length != 2) continue;
            if (keyVal[0].equals("codec")) {
                codec = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("frameSize")) {
                frameSize = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (!keyVal[0].equals("presentationTime")) continue;
            presentationTime = Double.parseDouble(keyVal[1]);
        }
        PartialFrameInfo frameInfo = new PartialFrameInfo();
        frameInfo.setCodec(codec);
        frameInfo.setFrameSize(frameSize);
        frameInfo.setPresentationTime(presentationTime);
        VrLogger.logI("frameInfo", "frameInfo: " + frameInfo.toString());
        return frameInfo;
    }

    public static ICatchGLStablizationInfo toStablizationInfo(String value) {
        String[] strValStrs;
        if (value == null) {
            return null;
        }
        float time = 0.0f;
        float raw = 0.0f;
        float roll = 0.0f;
        float pitch = 0.0f;
        for (String strVal : strValStrs = value.split(";")) {
            String[] keyVal = strVal.split("=");
            if (keyVal.length != 2) continue;
            if (keyVal[0].equals("time")) {
                time = Float.parseFloat(keyVal[1]);
            }
            if (keyVal[0].equals("raw")) {
                raw = Float.parseFloat(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("roll")) {
                roll = Float.parseFloat(keyVal[1]);
                continue;
            }
            if (!keyVal[0].equals("pitch")) continue;
            pitch = Float.parseFloat(keyVal[1]);
        }
        ICatchGLStablizationInfo stablizationInfo = new ICatchGLStablizationInfo();
        stablizationInfo.setTime(time);
        stablizationInfo.setRaw(raw);
        stablizationInfo.setRoll(roll);
        stablizationInfo.setPitch(pitch);
        return stablizationInfo;
    }

    public static ICatchVideoFormat toPartialVideoFormat(String value) {
        return DataTypeUtil.toPartialVideoFormat(value, ";");
    }

    public static ICatchVideoFormat toVideoFormat(String value) {
        return DataTypeUtil.toPartialVideoFormat(value, ",");
    }

    public static String toVideoFormat(ICatchVideoFormat videoFormat) {
        StringBuilder videoFormatS = new StringBuilder();
        videoFormatS.append("mineType=").append(videoFormat.getMineType()).append(",");
        videoFormatS.append("codec=").append(videoFormat.getCodec()).append(",");
        videoFormatS.append("videoW=").append(videoFormat.getVideoW()).append(",");
        videoFormatS.append("videoH=").append(videoFormat.getVideoH()).append(",");
        videoFormatS.append("bitrate=").append(videoFormat.getBitrate()).append(",");
        videoFormatS.append("durationUs=").append(videoFormat.getDurationUs()).append(",");
        videoFormatS.append("maxInputSize=").append(videoFormat.getMaxInputSize()).append(",");
        return videoFormatS.toString();
    }

    public static ICatchVideoFormat toPartialVideoFormat(String value, String seperator) {
        String[] strValStrs;
        if (value == null) {
            return null;
        }
        String mineType = "";
        int codec = 255;
        int videoW = 0;
        int videoH = 0;
        int bitrate = 0;
        int durationUs = 0;
        int maxInputSize = 0;
        int fps = 0;
        VrLogger.logI("DtaTypeUtil", "value: " + value);
        for (String strVal : strValStrs = value.split(seperator)) {
            String[] keyVal = strVal.split("=");
            VrLogger.logI("DtaTypeUtil", "strVal: " + strVal);
            VrLogger.logI("DtaTypeUtil", "keyVal: " + keyVal + "; len: " + keyVal.length);
            if (keyVal.length != 2) continue;
            if (keyVal[0].equals("mineType")) {
                mineType = keyVal[1];
                continue;
            }
            if (keyVal[0].equals("codec")) {
                codec = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("videoW")) {
                videoW = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("videoH")) {
                videoH = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("bitrate")) {
                bitrate = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("durationUs")) {
                durationUs = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("maxInputSize")) {
                maxInputSize = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (!keyVal[0].equals("fps")) continue;
            fps = Integer.parseInt(keyVal[1]);
        }
        VrLogger.logI("DtaTypeUtil", "mineType: " + mineType);
        VrLogger.logI("DtaTypeUtil", "codec: " + codec);
        VrLogger.logI("DtaTypeUtil", "videoW: " + videoW);
        VrLogger.logI("DtaTypeUtil", "videoH: " + videoH);
        VrLogger.logI("DtaTypeUtil", "bitrate: " + bitrate);
        VrLogger.logI("DtaTypeUtil", "durationUs: " + durationUs);
        VrLogger.logI("DtaTypeUtil", "maxInputSize: " + maxInputSize);
        VrLogger.logI("DtaTypeUtil", "fps: " + fps);
        ICatchVideoFormat videoFormat = new ICatchVideoFormat();
        videoFormat.setMineType(mineType);
        videoFormat.setCodec(codec);
        videoFormat.setVideoW(videoW);
        videoFormat.setVideoH(videoH);
        videoFormat.setBitrate(bitrate);
        videoFormat.setDurationUs(durationUs);
        videoFormat.setMaxInputSize(maxInputSize);
        videoFormat.setFrameRate(fps);
        return videoFormat;
    }

    public static ICatchAudioFormat toPartialAudioFormat(String value) {
        String[] strValStrs;
        if (value == null) {
            return null;
        }
        int codec = 255;
        int frequency = 44100;
        int nChannels = 2;
        int sampleBits = 16;
        VrLogger.logI("DtaTypeUtil", "value: " + value);
        for (String strVal : strValStrs = value.split(";")) {
            String[] keyVal = strVal.split("=");
            VrLogger.logI("DtaTypeUtil", "strVal: " + strVal);
            VrLogger.logI("DtaTypeUtil", "keyVal: " + keyVal + "; len: " + keyVal.length);
            if (keyVal.length != 2) continue;
            if (keyVal[0].equals("codec")) {
                codec = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("frequency")) {
                frequency = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("nChannels")) {
                nChannels = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (!keyVal[0].equals("sampleBits")) continue;
            sampleBits = Integer.parseInt(keyVal[1]);
        }
        VrLogger.logI("DtaTypeUtil", "codec: " + codec);
        VrLogger.logI("DtaTypeUtil", "frequency: " + frequency);
        VrLogger.logI("DtaTypeUtil", "nChannels: " + nChannels);
        VrLogger.logI("DtaTypeUtil", "sampleBits: " + sampleBits);
        ICatchAudioFormat audioFormat = new ICatchAudioFormat();
        audioFormat.setCodec(codec);
        audioFormat.setFrequency(frequency);
        audioFormat.setNChannels(nChannels);
        audioFormat.setSampleBits(sampleBits);
        return audioFormat;
    }

    public static List<ICatchImageSize> toImageSizes(String ntvImageSizesStr) {
        String[] imageSizeAttris;
        LinkedList<ICatchImageSize> imageSizes = new LinkedList<ICatchImageSize>();
        if (ntvImageSizesStr == null) {
            return imageSizes;
        }
        for (String imageSizeAttr : imageSizeAttris = ntvImageSizesStr.split(";")) {
            imageSizes.add(DataTypeUtil.toImageSize(imageSizeAttr));
        }
        return imageSizes;
    }

    public static ICatchImageSize toImageSize(String substring) {
        String[] imageSizeAttrs;
        int imageW = 0;
        int imageH = 0;
        VrLogger.logI("DtaTypeUtil", "toImageSize: " + substring);
        for (String imageSizeAttr : imageSizeAttrs = substring.split(",")) {
            String[] keyVal = imageSizeAttr.split("=");
            VrLogger.logI("DtaTypeUtil", "imageSizeAttr: " + imageSizeAttr);
            VrLogger.logI("DtaTypeUtil", "keyVal: " + keyVal + "; len: " + keyVal.length);
            if (keyVal.length != 2) continue;
            if (keyVal[0].equals("imageW")) {
                imageW = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (!keyVal[0].equals("imageH")) continue;
            imageH = Integer.parseInt(keyVal[1]);
        }
        VrLogger.logI("DtaTypeUtil", "imageW: " + imageW);
        VrLogger.logI("DtaTypeUtil", "imageH: " + imageH);
        ICatchImageSize imageSize = new ICatchImageSize();
        imageSize.setImageW(imageW);
        imageSize.setImageH(imageH);
        return imageSize;
    }
}

