/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.jni.extractor;

import android.annotation.SuppressLint;
import java.util.HashMap;
import java.util.Map;

public class ExceptionUtil {
    private static Map<Integer, String> innerMsgMapping;

    public static String getErrorMessage(int errorID) {
        if (innerMsgMapping == null) {
            ExceptionUtil.initMsgMapping();
        }
        if (innerMsgMapping == null) {
            return "unknown exception description, innerMsgMapping is null";
        }
        String message = innerMsgMapping.get(errorID);
        if (message == null) {
            return "unknown exception information, id: " + errorID;
        }
        return message;
    }

    @SuppressLint(value={"UseSparseArrays"})
    private static void initMsgMapping() {
        innerMsgMapping = new HashMap<Integer, String>();
        innerMsgMapping.put(-1, "device busy");
        innerMsgMapping.put(-2, "device error");
        innerMsgMapping.put(-3, "not supported");
        innerMsgMapping.put(-4, "not implemented");
        innerMsgMapping.put(-5, "permission denied");
        innerMsgMapping.put(-6, "try again");
        innerMsgMapping.put(-7, "buffer too small");
        innerMsgMapping.put(-8, "out of memory");
        innerMsgMapping.put(-9, "file not found");
        innerMsgMapping.put(-10, "path not found");
        innerMsgMapping.put(-11, "invalid session");
        innerMsgMapping.put(-12, "invalid argument");
        innerMsgMapping.put(-13, "socket error");
        innerMsgMapping.put(-14, "connection disconnected(wifi)");
        innerMsgMapping.put(-21, "io failed");
        innerMsgMapping.put(-22, "access denied");
        innerMsgMapping.put(-23, "no such device");
        innerMsgMapping.put(-24, "device not found");
        innerMsgMapping.put(-25, "device or resource busy");
        innerMsgMapping.put(-26, "operation timeout");
        innerMsgMapping.put(-27, "memory or resource overflow");
        innerMsgMapping.put(-28, "pipe error");
        innerMsgMapping.put(-29, "operation interrupted");
        innerMsgMapping.put(-30, "invalid device");
        innerMsgMapping.put(-31, "invalid mode");
        innerMsgMapping.put(-40, "call back exception");
        innerMsgMapping.put(-41, "native (java) operation failed");
        innerMsgMapping.put(-42, "no such usb interface");
        innerMsgMapping.put(-43, "no such usb endpoint");
        innerMsgMapping.put(-44, "usb frame info error");
        innerMsgMapping.put(-45, "usb stream error");
        innerMsgMapping.put(-60, "listener exists");
        innerMsgMapping.put(-61, "listener not exists");
        innerMsgMapping.put(-71, "seek failed");
        innerMsgMapping.put(-72, "pause failed");
        innerMsgMapping.put(-73, "resume failed");
        innerMsgMapping.put(-81, "playback memory full");
        innerMsgMapping.put(-82, "playback caching");
        innerMsgMapping.put(-83, "playback ended");
        innerMsgMapping.put(-84, "playback stream paused");
        innerMsgMapping.put(-90, "video stream closed");
        innerMsgMapping.put(-91, "audio stream closed");
        innerMsgMapping.put(-92, "stream not running");
        innerMsgMapping.put(-93, "stream not supported");
        innerMsgMapping.put(-100, "session's password not correct");
        innerMsgMapping.put(-101, "setup ptp connection failed");
        innerMsgMapping.put(-102, "wait timeout");
        innerMsgMapping.put(-103, "publish already started");
        innerMsgMapping.put(-104, "publish already stopped");
        innerMsgMapping.put(-110, "muxer already started");
        innerMsgMapping.put(-111, "muxer start failed");
        innerMsgMapping.put(-112, "muxer not started");
        innerMsgMapping.put(-113, "muxer waiting key frame");
        innerMsgMapping.put(-120, "open failed");
        innerMsgMapping.put(-202, "resource not ready");
        innerMsgMapping.put(-203, "session exists");
        innerMsgMapping.put(-204, "session not exists");
        innerMsgMapping.put(-205, "stream playing ended");
        innerMsgMapping.put(-206, "stream already started");
        innerMsgMapping.put(-207, "transport error");
        innerMsgMapping.put(-210, "render not init");
        innerMsgMapping.put(-211, "render already init");
        innerMsgMapping.put(-212, "render not started");
        innerMsgMapping.put(-213, "render already started");
        innerMsgMapping.put(-214, "surface not set");
        innerMsgMapping.put(-215, "surface already set");
        innerMsgMapping.put(-216, "format not supported");
        innerMsgMapping.put(-217, "format not specified");
        innerMsgMapping.put(-218, "picture not specified");
        innerMsgMapping.put(-219, "sphere type not supported");
        innerMsgMapping.put(-220, "not init");
        innerMsgMapping.put(-221, "already init");
        innerMsgMapping.put(-255, "unknown error");
    }
}

