/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.jni.extractor;

import com.icatchtek.pancam.core.jni.extractor.ExceptionUtil;
import com.icatchtek.pancam.core.jni.extractor.NativeValueUtil;
import com.icatchtek.pancam.core.util.VrLogger;
import com.icatchtek.pancam.customer.exception.IchGLAlreadyInitedException;
import com.icatchtek.pancam.customer.exception.IchGLFormatNotSpecifiedException;
import com.icatchtek.pancam.customer.exception.IchGLFormatNotSupportedException;
import com.icatchtek.pancam.customer.exception.IchGLNotInitedException;
import com.icatchtek.pancam.customer.exception.IchGLPanoramaTypeNotSupportedException;
import com.icatchtek.pancam.customer.exception.IchGLPictureNotSpecifiedException;
import com.icatchtek.pancam.customer.exception.IchGLRenderAlreadyInitedException;
import com.icatchtek.pancam.customer.exception.IchGLRenderAlreadyStartedException;
import com.icatchtek.pancam.customer.exception.IchGLRenderNotInitedException;
import com.icatchtek.pancam.customer.exception.IchGLRenderNotStartedException;
import com.icatchtek.pancam.customer.exception.IchGLResourceNotReadyException;
import com.icatchtek.pancam.customer.exception.IchGLSurfaceAlreadySetException;
import com.icatchtek.pancam.customer.exception.IchGLSurfaceNotSetException;
import com.icatchtek.reliant.customer.exception.IchAudioStreamClosedException;
import com.icatchtek.reliant.customer.exception.IchBufferTooSmallException;
import com.icatchtek.reliant.customer.exception.IchFileNotFoundException;
import com.icatchtek.reliant.customer.exception.IchImageSizeNotSpecifiedException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchListenerExistsException;
import com.icatchtek.reliant.customer.exception.IchListenerNotExistsException;
import com.icatchtek.reliant.customer.exception.IchMuxerAlreadyStartedException;
import com.icatchtek.reliant.customer.exception.IchMuxerNotStartedException;
import com.icatchtek.reliant.customer.exception.IchMuxerStartFailedException;
import com.icatchtek.reliant.customer.exception.IchNotImplementedException;
import com.icatchtek.reliant.customer.exception.IchNotSupportedException;
import com.icatchtek.reliant.customer.exception.IchOutOfMemoryException;
import com.icatchtek.reliant.customer.exception.IchPauseFailedException;
import com.icatchtek.reliant.customer.exception.IchPbStreamPausedException;
import com.icatchtek.reliant.customer.exception.IchPermissionDeniedException;
import com.icatchtek.reliant.customer.exception.IchResumeFailedException;
import com.icatchtek.reliant.customer.exception.IchSeekFailedException;
import com.icatchtek.reliant.customer.exception.IchSessionExistsException;
import com.icatchtek.reliant.customer.exception.IchSessionNotExistsException;
import com.icatchtek.reliant.customer.exception.IchStreamNotRunningException;
import com.icatchtek.reliant.customer.exception.IchStreamNotSupportException;
import com.icatchtek.reliant.customer.exception.IchStreamPlayingEndedException;
import com.icatchtek.reliant.customer.exception.IchStreamPublishException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.exception.IchUnknownException;
import com.icatchtek.reliant.customer.exception.IchVideoStreamClosedException;

public class NativeValueExtractor {
    public static String extractNativeStringValue(String content) throws IchInvalidArgumentException, IchInvalidSessionException, IchListenerExistsException, IchListenerNotExistsException, IchNotImplementedException, IchGLResourceNotReadyException, IchStreamNotRunningException, IchStreamPlayingEndedException, IchOutOfMemoryException, IchSessionExistsException, IchSessionNotExistsException, IchUnknownException, IchFileNotFoundException, IchNotSupportedException, IchGLPictureNotSpecifiedException, IchGLRenderAlreadyStartedException, IchGLSurfaceAlreadySetException, IchGLFormatNotSpecifiedException, IchGLRenderNotInitedException, IchGLRenderNotStartedException, IchGLSurfaceNotSetException, IchGLFormatNotSupportedException, IchGLRenderAlreadyInitedException, IchGLPanoramaTypeNotSupportedException, IchGLNotInitedException, IchGLAlreadyInitedException, IchImageSizeNotSpecifiedException, IchTransportException, IchTryAgainException, IchBufferTooSmallException, IchStreamNotSupportException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchSeekFailedException, IchPauseFailedException, IchResumeFailedException, IchPbStreamPausedException, IchMuxerStartFailedException, IchMuxerNotStartedException, IchMuxerAlreadyStartedException, IchStreamPublishException, IchPermissionDeniedException {
        if (content.contains("RET_ERR")) {
            int errorID = NativeValueUtil.getErrValue(content);
            NativeValueExtractor.errorToException(errorID);
        }
        if (content.contains("RET_STRING")) {
            return NativeValueUtil.getStringValue(content);
        }
        VrLogger.logE("NativeValueExtractor", "Fatal error, invalid data from jni layer." + content);
        return null;
    }

    public static int extractNativeIntValue(String content) throws IchInvalidArgumentException, IchInvalidSessionException, IchListenerExistsException, IchListenerNotExistsException, IchNotImplementedException, IchGLResourceNotReadyException, IchStreamNotRunningException, IchStreamPlayingEndedException, IchOutOfMemoryException, IchSessionExistsException, IchSessionNotExistsException, IchUnknownException, IchFileNotFoundException, IchNotSupportedException, IchGLPictureNotSpecifiedException, IchGLRenderAlreadyStartedException, IchGLSurfaceAlreadySetException, IchGLFormatNotSpecifiedException, IchGLRenderNotInitedException, IchGLRenderNotStartedException, IchGLSurfaceNotSetException, IchGLFormatNotSupportedException, IchGLRenderAlreadyInitedException, IchGLPanoramaTypeNotSupportedException, IchGLNotInitedException, IchGLAlreadyInitedException, IchImageSizeNotSpecifiedException, IchTransportException, IchTryAgainException, IchBufferTooSmallException, IchStreamNotSupportException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchSeekFailedException, IchPauseFailedException, IchResumeFailedException, IchPbStreamPausedException, IchMuxerStartFailedException, IchMuxerNotStartedException, IchMuxerAlreadyStartedException, IchStreamPublishException, IchPermissionDeniedException {
        if (content.contains("RET_ERR")) {
            int errorID = NativeValueUtil.getErrValue(content);
            NativeValueExtractor.errorToException(errorID);
        }
        if (content.contains("RET_INT")) {
            return NativeValueUtil.getIntValue(content);
        }
        VrLogger.logE("NativeValueExtractor", "Fatal error, invalid data from jni layer." + content);
        return -1;
    }

    public static long extractNativeLongValue(String content) throws IchInvalidArgumentException, IchInvalidSessionException, IchListenerExistsException, IchListenerNotExistsException, IchNotImplementedException, IchGLResourceNotReadyException, IchStreamNotRunningException, IchStreamPlayingEndedException, IchOutOfMemoryException, IchSessionExistsException, IchSessionNotExistsException, IchUnknownException, IchFileNotFoundException, IchNotSupportedException, IchGLPictureNotSpecifiedException, IchGLRenderAlreadyStartedException, IchGLSurfaceAlreadySetException, IchGLFormatNotSpecifiedException, IchGLRenderNotInitedException, IchGLRenderNotStartedException, IchGLSurfaceNotSetException, IchGLFormatNotSupportedException, IchGLRenderAlreadyInitedException, IchGLPanoramaTypeNotSupportedException, IchGLNotInitedException, IchGLAlreadyInitedException, IchImageSizeNotSpecifiedException, IchTransportException, IchTryAgainException, IchBufferTooSmallException, IchStreamNotSupportException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchSeekFailedException, IchPauseFailedException, IchResumeFailedException, IchPbStreamPausedException, IchMuxerStartFailedException, IchMuxerNotStartedException, IchMuxerAlreadyStartedException, IchStreamPublishException, IchPermissionDeniedException {
        if (content.contains("RET_ERR")) {
            int errorID = NativeValueUtil.getErrValue(content);
            NativeValueExtractor.errorToException(errorID);
        }
        if (content.contains("RET_LONG")) {
            return NativeValueUtil.getLongValue(content);
        }
        VrLogger.logE("NativeValueExtractor", "Fatal error, invalid data from jni layer." + content);
        return -1L;
    }

    public static boolean extractNativeBoolValue(String content) throws IchInvalidArgumentException, IchInvalidSessionException, IchListenerExistsException, IchListenerNotExistsException, IchNotImplementedException, IchGLResourceNotReadyException, IchStreamNotRunningException, IchStreamPlayingEndedException, IchOutOfMemoryException, IchSessionExistsException, IchSessionNotExistsException, IchUnknownException, IchFileNotFoundException, IchNotSupportedException, IchGLPictureNotSpecifiedException, IchGLRenderAlreadyStartedException, IchGLSurfaceAlreadySetException, IchGLFormatNotSpecifiedException, IchGLRenderNotInitedException, IchGLRenderNotStartedException, IchGLSurfaceNotSetException, IchGLFormatNotSupportedException, IchGLRenderAlreadyInitedException, IchGLPanoramaTypeNotSupportedException, IchGLNotInitedException, IchGLAlreadyInitedException, IchImageSizeNotSpecifiedException, IchTransportException, IchTryAgainException, IchBufferTooSmallException, IchStreamNotSupportException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchSeekFailedException, IchPauseFailedException, IchResumeFailedException, IchPbStreamPausedException, IchMuxerStartFailedException, IchMuxerNotStartedException, IchMuxerAlreadyStartedException, IchStreamPublishException, IchPermissionDeniedException {
        if (content.contains("RET_ERR")) {
            int errorID = NativeValueUtil.getErrValue(content);
            NativeValueExtractor.errorToException(errorID);
        }
        if (content.contains("RET_BOOL")) {
            return NativeValueUtil.getBoolValue(content);
        }
        VrLogger.logE("NativeValueExtractor", "Fatal error, invalid data from jni layer." + content);
        return false;
    }

    public static double extractNativeDoubleValue(String content) throws IchInvalidArgumentException, IchInvalidSessionException, IchListenerExistsException, IchListenerNotExistsException, IchNotImplementedException, IchGLResourceNotReadyException, IchStreamNotRunningException, IchStreamPlayingEndedException, IchOutOfMemoryException, IchSessionExistsException, IchSessionNotExistsException, IchUnknownException, IchFileNotFoundException, IchNotSupportedException, IchGLPictureNotSpecifiedException, IchGLRenderAlreadyStartedException, IchGLSurfaceAlreadySetException, IchGLFormatNotSpecifiedException, IchGLRenderNotInitedException, IchGLRenderNotStartedException, IchGLSurfaceNotSetException, IchGLFormatNotSupportedException, IchGLRenderAlreadyInitedException, IchGLPanoramaTypeNotSupportedException, IchGLNotInitedException, IchGLAlreadyInitedException, IchImageSizeNotSpecifiedException, IchTransportException, IchTryAgainException, IchBufferTooSmallException, IchStreamNotSupportException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchSeekFailedException, IchPauseFailedException, IchResumeFailedException, IchPbStreamPausedException, IchMuxerStartFailedException, IchMuxerNotStartedException, IchMuxerAlreadyStartedException, IchStreamPublishException, IchPermissionDeniedException {
        if (content.contains("RET_ERR")) {
            int errorID = NativeValueUtil.getErrValue(content);
            NativeValueExtractor.errorToException(errorID);
        }
        if (content.contains("RET_DOUBLE")) {
            return NativeValueUtil.getDoubleValue(content);
        }
        VrLogger.logE("NativeValueExtractor", "Fatal error, invalid data from jni layer. " + content);
        return -1.0;
    }

    private static void errorToException(int errorID) throws IchInvalidArgumentException, IchInvalidSessionException, IchNotSupportedException, IchListenerExistsException, IchListenerNotExistsException, IchNotImplementedException, IchGLResourceNotReadyException, IchStreamNotRunningException, IchGLAlreadyInitedException, IchStreamPlayingEndedException, IchOutOfMemoryException, IchSessionExistsException, IchSessionNotExistsException, IchFileNotFoundException, IchUnknownException, IchGLRenderNotInitedException, IchGLRenderAlreadyInitedException, IchGLRenderNotStartedException, IchGLRenderAlreadyStartedException, IchGLSurfaceNotSetException, IchGLSurfaceAlreadySetException, IchGLFormatNotSupportedException, IchGLFormatNotSpecifiedException, IchGLPictureNotSpecifiedException, IchGLPanoramaTypeNotSupportedException, IchGLNotInitedException, IchImageSizeNotSpecifiedException, IchTransportException, IchTryAgainException, IchBufferTooSmallException, IchStreamNotSupportException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchSeekFailedException, IchPauseFailedException, IchResumeFailedException, IchPbStreamPausedException, IchMuxerStartFailedException, IchMuxerNotStartedException, IchMuxerAlreadyStartedException, IchStreamPublishException, IchPermissionDeniedException {
        switch (errorID) {
            case -207: {
                throw new IchTransportException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -6: {
                throw new IchTryAgainException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -7: {
                throw new IchBufferTooSmallException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -12: {
                throw new IchInvalidArgumentException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -11: {
                throw new IchInvalidSessionException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -3: {
                throw new IchNotSupportedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -202: {
                throw new IchGLResourceNotReadyException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -8: {
                throw new IchOutOfMemoryException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -9: {
                throw new IchFileNotFoundException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -203: {
                throw new IchSessionExistsException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -204: {
                throw new IchSessionNotExistsException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -60: {
                throw new IchListenerExistsException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -61: {
                throw new IchListenerNotExistsException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -210: {
                throw new IchGLRenderNotInitedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -211: {
                throw new IchGLRenderAlreadyInitedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -212: {
                throw new IchGLRenderNotStartedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -213: {
                throw new IchGLRenderAlreadyStartedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -214: {
                throw new IchGLSurfaceNotSetException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -215: {
                throw new IchGLSurfaceAlreadySetException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -216: {
                throw new IchGLFormatNotSupportedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -217: {
                throw new IchGLFormatNotSpecifiedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -218: {
                throw new IchGLPictureNotSpecifiedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -219: {
                throw new IchGLNotInitedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -220: {
                throw new IchGLNotInitedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -221: {
                throw new IchGLAlreadyInitedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -92: {
                throw new IchStreamNotRunningException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -93: {
                throw new IchStreamNotSupportException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -90: {
                throw new IchVideoStreamClosedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -91: {
                throw new IchAudioStreamClosedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -205: {
                throw new IchStreamPlayingEndedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -71: {
                throw new IchSeekFailedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -72: {
                throw new IchPauseFailedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -73: {
                throw new IchResumeFailedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -84: {
                throw new IchPbStreamPausedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -5: {
                throw new IchPermissionDeniedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -110: {
                throw new IchMuxerAlreadyStartedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -112: {
                throw new IchMuxerNotStartedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -111: {
                throw new IchMuxerStartFailedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -103: {
                throw new IchStreamPublishException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -104: {
                throw new IchStreamPublishException(ExceptionUtil.getErrorMessage(errorID));
            }
        }
        VrLogger.logE("error Exception mapping", "unknown errorID: " + errorID);
        throw new IchUnknownException(ExceptionUtil.getErrorMessage(errorID));
    }
}

