/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.util.type;

import android.annotation.SuppressLint;
import com.icatchtek.pancam.core.util.VrLogger;
import com.icatchtek.reliant.customer.type.ICatchFile;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NativeFile {
    private static final int TYPE_IMAGE = 1;
    private static final int TYPE_VIDEO = 2;
    private static final int TYPE_AUDIO = 4;
    private static final int TYPE_TEXT = 8;
    private static final int TYPE_ALL = 15;
    private static final int TYPE_UNKNOWN = 16;
    private static Map<Integer, Integer> types;

    @SuppressLint(value={"UseSparseArrays"})
    private static void fillFileTypes() {
        types = new HashMap<Integer, Integer>();
        types.put(1, 1);
        types.put(2, 2);
        types.put(4, 4);
        types.put(8, 8);
        types.put(15, 15);
        types.put(16, 16);
    }

    public static List<ICatchFile> toIcatchFiles(String ntvfilesStr) {
        String[] fileObjStrs;
        LinkedList<ICatchFile> files = new LinkedList<ICatchFile>();
        if (ntvfilesStr == null) {
            return files;
        }
        for (String fileObjStr : fileObjStrs = ntvfilesStr.split(";")) {
            files.add(NativeFile.toICatchFile(fileObjStr));
        }
        return files;
    }

    public static ICatchFile toICatchFile(String substring) {
        String[] fileAttrs;
        int fileHandle = -1;
        String filePath = "";
        String fileName = "";
        String fileDate = "";
        long fileSize = -1L;
        double frameRate = 0.0;
        int fileWidth = 0;
        int fileHeight = 0;
        int fileType = 16;
        int fileDuration = 0;
        for (String fileAttr : fileAttrs = substring.split(",")) {
            String[] keyVal = fileAttr.split("=");
            if (keyVal.length != 2) continue;
            if (keyVal[0].equals("handle")) {
                fileHandle = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("path")) {
                filePath = keyVal[1];
                continue;
            }
            if (keyVal[0].equals("name")) {
                fileName = keyVal[1];
                continue;
            }
            if (keyVal[0].equals("date")) {
                fileDate = keyVal[1];
                continue;
            }
            if (keyVal[0].equals("type")) {
                fileType = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("size")) {
                fileSize = Long.parseLong(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("framerate")) {
                frameRate = Double.parseDouble(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("width")) {
                fileWidth = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (keyVal[0].equals("height")) {
                fileHeight = Integer.parseInt(keyVal[1]);
                continue;
            }
            if (!keyVal[0].equals("fileDuration")) continue;
            fileDuration = Integer.parseInt(keyVal[1]);
        }
        VrLogger.logI("toIcatchFile", "fileHandle: " + fileHandle);
        VrLogger.logI("toIcatchFile", "filePath: " + filePath);
        VrLogger.logI("toIcatchFile", "fileName: " + fileName);
        VrLogger.logI("toIcatchFile", "fileDate: " + fileDate);
        VrLogger.logI("toIcatchFile", "fileType: " + fileType);
        VrLogger.logI("toIcatchFile", "fileSize: " + fileSize);
        VrLogger.logI("toIcatchFile", "framerate: " + frameRate);
        VrLogger.logI("toIcatchFile", "fileWidth: " + fileWidth);
        VrLogger.logI("toIcatchFile", "fileHeight: " + fileHeight);
        VrLogger.logI("toIcatchFile", "fileDuration: " + fileDuration);
        if (fileHandle < 0) {
            return null;
        }
        return new ICatchFile(fileHandle, fileType, filePath, fileName, fileSize, fileDate, frameRate, fileWidth, fileHeight, 0, fileDuration);
    }

    public static String toICatchFile(ICatchFile file) {
        String filePath = file.getFilePath();
        String fileName = file.getFileName();
        String fileDate = file.getFileDate();
        int fileType = file.getFileType();
        StringBuilder sb = new StringBuilder();
        sb.append("handle=").append(file.getFileHandle()).append(",");
        sb.append("path=").append(filePath != null ? filePath : "").append(",");
        sb.append("name=").append(fileName != null ? fileName : "").append(",");
        sb.append("date=").append(fileDate != null ? fileDate : "").append(",");
        sb.append("type=").append(fileType).append(",");
        sb.append("size=").append(file.getFileSize()).append(",");
        sb.append("framerate=").append(file.getFrameRate()).append(",");
        sb.append("width=").append(file.getFileWidth()).append(",");
        sb.append("height=").append(file.getFileHeight()).append(",");
        sb.append("fileDuration=").append(file.getFileDuration()).append(",");
        return sb.toString();
    }
}

