/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.customer;

import android.os.Build;
import com.icatchtek.pancam.core.feature.ICatchPancamControl;
import com.icatchtek.pancam.core.feature.ICatchPancamImage;
import com.icatchtek.pancam.core.feature.ICatchPancamPreview;
import com.icatchtek.pancam.core.feature.ICatchPancamVideoPlayback;
import com.icatchtek.pancam.core.jni.JPancamSession;
import com.icatchtek.pancam.core.util.VrLogger;
import com.icatchtek.pancam.core.util.event.CoreEventListener;
import com.icatchtek.pancam.customer.ICatchIPancamControl;
import com.icatchtek.pancam.customer.ICatchIPancamImage;
import com.icatchtek.pancam.customer.ICatchIPancamListener;
import com.icatchtek.pancam.customer.ICatchIPancamPreview;
import com.icatchtek.pancam.customer.ICatchIPancamVideoPlayback;
import com.icatchtek.pancam.customer.ICatchPancamInfo;
import com.icatchtek.pancam.customer.type.ICatchGLColor;
import com.icatchtek.pancam.customer.type.ICatchGLDisplayPPI;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchListenerExistsException;
import com.icatchtek.reliant.customer.exception.IchListenerNotExistsException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.transport.ICatchINETTransport;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCBulkTransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCIsoTransport;
import com.icatchtek.reliant.customer.transport.ICatchUsbScsiTransport;

public final class ICatchPancamSession {
    private int sessionID = JPancamSession.createSession_Jni();
    private ICatchPancamInfo info;
    private ICatchIPancamControl control;
    private ICatchPancamImage image;
    private ICatchPancamPreview preview;
    private ICatchPancamVideoPlayback videoPlayback;

    private ICatchPancamSession() {
    }

    public static ICatchPancamSession createSession() {
        return new ICatchPancamSession();
    }

    @Deprecated
    public int getSessionID() {
        return this.sessionID;
    }

    public static boolean addEventListener(int eventID, ICatchIPancamListener listener, boolean forAllSession) throws IchListenerExistsException {
        CoreEventListener coreEventListener = new CoreEventListener(listener);
        return JPancamSession.addEventListener_Jni(eventID, coreEventListener, listener.hashCode(), forAllSession);
    }

    public static boolean delEventListener(int eventID, ICatchIPancamListener listener, boolean forAllSession) throws IchListenerNotExistsException {
        return JPancamSession.removeEventListener_Jni(eventID, listener.hashCode(), forAllSession);
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        JPancamSession.deleteSession_Jni(this.sessionID);
    }

    public boolean prepareSession(ICatchITransport transport, ICatchGLColor defaultColor, ICatchGLDisplayPPI displayPPI) throws IchTransportException {
        VrLogger.logI("SystemInfo", "Model: " + Build.MODEL);
        VrLogger.logI("SystemInfo", "API level: " + Build.VERSION.SDK_INT);
        VrLogger.logI("SystemInfo", "Android version: " + Build.VERSION.RELEASE);
        if (transport instanceof ICatchINETTransport) {
            String localIPAddr;
            String ipAddr = ((ICatchINETTransport)transport).getIpAddress();
            boolean retVal = JPancamSession.prepareSession_Jni(this.sessionID, ipAddr, localIPAddr = ((ICatchINETTransport)transport).getLocalIpAddress(), defaultColor, displayPPI);
            if (!retVal) {
                return false;
            }
        } else if (transport instanceof ICatchUVCBulkTransport) {
            boolean retVal = JPancamSession.prepareSession_Jni(this.sessionID, true, -1, -1, -1, defaultColor, displayPPI);
            if (!retVal) {
                return false;
            }
        } else if (transport instanceof ICatchUVCIsoTransport) {
            ICatchUVCIsoTransport isoTransport = (ICatchUVCIsoTransport)transport;
            boolean retVal = JPancamSession.prepareSession_Jni(this.sessionID, false, isoTransport.getVendorID(), isoTransport.getProductID(), isoTransport.getFileDescriptor(), defaultColor, displayPPI);
            if (!retVal) {
                return false;
            }
        } else if (transport instanceof ICatchUsbScsiTransport) {
            boolean retVal = JPancamSession.prepareSession_Jni(this.sessionID, true, -1, -1, -1, defaultColor, displayPPI);
            if (!retVal) {
                return false;
            }
        } else {
            throw new IchTransportException("Transport not supported [" + transport + "]");
        }
        this.info = new ICatchPancamInfo(this.sessionID);
        this.control = new ICatchPancamControl(this.sessionID);
        this.image = new ICatchPancamImage(this.sessionID);
        this.preview = new ICatchPancamPreview(this.sessionID, transport);
        this.videoPlayback = new ICatchPancamVideoPlayback(this.sessionID, transport);
        return true;
    }

    public boolean destroySession() throws IchInvalidSessionException {
        this.info = null;
        this.control = null;
        if (this.image != null) {
            this.image.releaseResource();
            this.image = null;
        }
        if (this.preview != null) {
            this.preview.releaseResource();
            this.preview = null;
        }
        if (this.videoPlayback != null) {
            this.videoPlayback.releaseResource();
        }
        JPancamSession.destroySession_Jni(this.sessionID);
        return true;
    }

    public ICatchPancamInfo getInfo() {
        return this.info;
    }

    public ICatchIPancamControl getControl() {
        return this.control;
    }

    public ICatchIPancamImage getImage() {
        return this.image;
    }

    public ICatchIPancamPreview getPreview() {
        return this.preview;
    }

    public ICatchIPancamVideoPlayback getVideoPlayback() {
        return this.videoPlayback;
    }
}

