/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.customer.type;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Environment;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ICatchGLImage {
    private Bitmap picture;

    public ICatchGLImage(Bitmap source) {
        this.picture = source;
    }

    public Bitmap getPicture() {
        return this.picture;
    }

    public void recycle() {
        if (this.picture != null) {
            this.picture.recycle();
            this.picture = null;
        }
    }

    public boolean save(String fileName) throws IOException {
        FileOutputStream outputStream;
        if (this.picture == null) {
            return false;
        }
        try {
            outputStream = new FileOutputStream(Environment.getExternalStorageDirectory() + "/" + fileName + ".jpg");
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw ex;
        }
        this.picture.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
        try {
            outputStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
        return true;
    }

    public static ICatchGLImage loadPicture(Context context, int resourceID) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        Bitmap picture = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceID, (BitmapFactory.Options)options);
        if (picture == null) {
            return null;
        }
        return new ICatchGLImage(picture);
    }

    public static ICatchGLImage crop(ICatchGLImage image, int x, int y, int width, int height) {
        Bitmap source = image.getPicture();
        if (source == null) {
            return null;
        }
        Bitmap dest = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)source.getConfig());
        Canvas canvas = new Canvas(dest);
        canvas.drawBitmap(source, new Rect(x, y, x + width, y + height), new Rect(0, 0, width, height), null);
        return new ICatchGLImage(dest);
    }

    public static ICatchGLImage rotate(ICatchGLImage image, int degree) {
        Bitmap source = image.getPicture();
        if (source == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        Bitmap dest = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
        return new ICatchGLImage(dest);
    }

    public static ICatchGLImage reverseBitmap(ICatchGLImage image, int flag) {
        Bitmap source = image.getPicture();
        if (source == null) {
            return null;
        }
        float[] floats = null;
        switch (flag) {
            case 0: {
                floats = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
                break;
            }
            case 1: {
                floats = new float[]{1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            }
        }
        if (floats == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.setValues(floats);
        Bitmap dest = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
        return new ICatchGLImage(dest);
    }
}

