/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.customer.type;

import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;

public class ICatchGLImageRaw {
    private byte[] buffer;
    private int format;
    private int imageW;
    private int imageH;

    public ICatchGLImageRaw(int format, int imageW, int imageH) throws IchInvalidArgumentException {
        this.init(format, imageW, imageH);
    }

    public ICatchGLImageRaw(int format, int imageW, int imageH, byte[] buffer) throws IchInvalidArgumentException {
        this.init(format, imageW, imageH);
        if (buffer.length < imageW * imageH * 4) {
            throw new IchInvalidArgumentException("This buffer does not contains enough data.");
        }
        System.arraycopy(buffer, 0, this.buffer, 0, buffer.length);
    }

    public int getFormat() {
        return this.format;
    }

    public int getImageW() {
        return this.imageW;
    }

    public int getImageH() {
        return this.imageH;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    private void init(int format, int imageW, int imageH) throws IchInvalidArgumentException {
        if (imageW <= 0 || imageH <= 0) {
            throw new IchInvalidArgumentException("This imageW or imageH should be less or equal than zero.");
        }
        this.buffer = new byte[imageW * imageH * 4];
        this.format = format;
        this.imageW = imageW;
        this.imageH = imageH;
    }
}

