/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.reliant.core;

import android.annotation.TargetApi;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import com.icatchtek.reliant.core.jni.JUsbTransportBulk;

public class UsbTransportBulkUtil {
    public static void updateConnection(UsbDeviceConnection usbDeviceConnection) {
        JUsbTransportBulk.setUsbDeviceConnection_Jni(usbDeviceConnection);
    }

    @TargetApi(value=21)
    public static void updateInformation(UsbDevice usbDevice) {
        int configCount = usbDevice.getConfigurationCount();
        for (int iconfig = 0; iconfig < configCount; ++iconfig) {
            UsbConfiguration usbConfiguration = usbDevice.getConfiguration(iconfig);
            int configId = usbConfiguration.getId();
            int interfaceCount = usbConfiguration.getInterfaceCount();
            for (int iinterface = 0; iinterface < interfaceCount; ++iinterface) {
                UsbInterface usbInterface = usbConfiguration.getInterface(iinterface);
                int interfaceId = usbInterface.getId();
                int alternateSetting = usbInterface.getAlternateSetting();
                int endpointCount = usbInterface.getEndpointCount();
                for (int iendpoint = 0; iendpoint < endpointCount; ++iendpoint) {
                    UsbEndpoint endpoint = usbInterface.getEndpoint(iendpoint);
                    int endpointAddr = endpoint.getAddress();
                    JUsbTransportBulk.setUsbEndpoint_Jni(configId, interfaceId, alternateSetting, endpointAddr, endpoint);
                }
                JUsbTransportBulk.setUSBInterfaceInfo_Jni(configId, interfaceId, alternateSetting, usbInterface);
            }
            JUsbTransportBulk.setUsbConfigurationInfo_Jni(configId, usbConfiguration);
        }
    }

    public static void updateInformationJellyBean(UsbDevice usbDevice) {
        int configId = 1;
        int alternateSetting = 0;
        int ifaceCount = usbDevice.getInterfaceCount();
        for (int iface = 0; iface < ifaceCount; ++iface) {
            UsbInterface usbInterface = usbDevice.getInterface(iface);
            int interfaceId = usbInterface.getId();
            int endpointCount = usbInterface.getEndpointCount();
            for (int iendpoint = 0; iendpoint < endpointCount; ++iendpoint) {
                UsbEndpoint endpoint = usbInterface.getEndpoint(iendpoint);
                int endpointAddr = endpoint.getAddress();
                JUsbTransportBulk.setUsbEndpoint_Jni(configId, interfaceId, alternateSetting, endpointAddr, endpoint);
            }
            JUsbTransportBulk.setUSBInterfaceInfo_Jni(configId, interfaceId, alternateSetting, usbInterface);
        }
    }
}

