/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.reliant.customer.transport;

import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import org.json.JSONException;
import org.json.JSONObject;

public class ICatchINETTransport
implements ICatchITransport {
    private String ipAddress;
    private String localIpAddress;

    public ICatchINETTransport(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public ICatchINETTransport(String ipAddress, String localIpAddress) {
        this.ipAddress = ipAddress;
        this.localIpAddress = localIpAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getLocalIpAddress() {
        return this.localIpAddress;
    }

    public String toString() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("ipAddress", (Object)this.ipAddress);
            jsonObject.put("localIpAddress", (Object)this.localIpAddress);
            return jsonObject.toString();
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean prepareTransport() throws IchTransportException {
        return true;
    }

    @Override
    public boolean destroyTransport() throws IchTransportException {
        return true;
    }

    public static ICatchINETTransport fromString(String attributes) {
        try {
            JSONObject jsonObject = new JSONObject(attributes);
            String ipAddress = jsonObject.getString("ipAddress");
            String localIpAddress = jsonObject.getString("localIpAddress");
            return new ICatchINETTransport(ipAddress, localIpAddress);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

