/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.reliant.customer.transport;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.os.Build;
import com.icatchtek.reliant.core.UsbTransportBulkUtil;
import com.icatchtek.reliant.core.jni.JUsbTransportCore;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.transport.ICatchITransport;

public class ICatchUVCBulkTransport
implements ICatchITransport {
    public ICatchUVCBulkTransport(UsbDevice usbDevice, UsbDeviceConnection usbDeviceConnection) throws IchInvalidArgumentException, IchTransportException {
        if (usbDevice == null || usbDeviceConnection == null) {
            throw new IchInvalidArgumentException("The usb device and its connection should not be null.");
        }
        if (Build.VERSION.SDK_INT < 21) {
            throw new IchTransportException("Not supported api level, transport need api level >= lollipop(21)");
        }
        UsbTransportBulkUtil.updateConnection(usbDeviceConnection);
        UsbTransportBulkUtil.updateInformation(usbDevice);
    }

    @Override
    public boolean prepareTransport() throws IchTransportException {
        return JUsbTransportCore.initUvc_Jni();
    }

    @Override
    public boolean destroyTransport() throws IchTransportException {
        return JUsbTransportCore.release_Jni();
    }
}

