/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.reliant.customer.transport;

import com.icatchtek.reliant.core.jni.JUsbTransportCore;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import org.json.JSONException;
import org.json.JSONObject;

public class ICatchUVCIsoTransport
implements ICatchITransport {
    private int vendorID;
    private int productID;
    private int fileDescriptor;

    public ICatchUVCIsoTransport(int vendorID, int productID, int fileDescriptor) throws IchInvalidArgumentException, IchTransportException {
        if (vendorID < 0 || productID < 0) {
            throw new IchInvalidArgumentException("The usb device and its connection should not be null.");
        }
        this.vendorID = vendorID;
        this.productID = productID;
        this.fileDescriptor = fileDescriptor;
    }

    public int getVendorID() {
        return this.vendorID;
    }

    public int getProductID() {
        return this.productID;
    }

    public int getFileDescriptor() {
        return this.fileDescriptor;
    }

    public void setFileDescriptor(int fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }

    @Override
    public boolean prepareTransport() throws IchTransportException {
        return JUsbTransportCore.initUvc_Jni(this.vendorID, this.productID, "", this.fileDescriptor);
    }

    @Override
    public boolean destroyTransport() throws IchTransportException {
        return JUsbTransportCore.release_Jni();
    }

    public String toString() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("vendorID", this.vendorID);
            jsonObject.put("productID", this.productID);
            jsonObject.put("fileDescriptor", this.fileDescriptor);
            return jsonObject.toString();
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ICatchUVCIsoTransport fromString(String attributes) throws IchInvalidArgumentException, IchTransportException {
        try {
            JSONObject jsonObject = new JSONObject(attributes);
            int vendorID = jsonObject.getInt("vendorID");
            int productID = jsonObject.getInt("productID");
            int fileDescriptor = jsonObject.getInt("fileDescriptor");
            return new ICatchUVCIsoTransport(vendorID, productID, fileDescriptor);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

