/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.reliant.customer.transport;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.os.Build;
import com.icatchtek.reliant.core.UsbTransportBulkUtil;
import com.icatchtek.reliant.core.jni.JUsbTransportCore;
import com.icatchtek.reliant.core.jni.JUsbTransportMsdc;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import com.icatchtek.reliant.customer.type.ICatchScsiCommandInfo;

public class ICatchUsbScsiTransport
implements ICatchITransport {
    private String deviceName;
    public static final int USB_TRANSPORT_ERROR_TRY_AGAIN = -200;

    public ICatchUsbScsiTransport(UsbDevice usbDevice, UsbDeviceConnection usbDeviceConnection) throws IchInvalidArgumentException, IchTransportException {
        if (usbDevice == null) {
            throw new IchInvalidArgumentException("The usb device and its connection should not be null.");
        }
        if (Build.VERSION.SDK_INT < 16) {
            throw new IchTransportException("Not supported api level, transport need api level >= jelly_bean(16)");
        }
        this.deviceName = usbDevice.getDeviceName();
        if (usbDeviceConnection != null) {
            UsbTransportBulkUtil.updateConnection(usbDeviceConnection);
        }
        UsbTransportBulkUtil.updateInformationJellyBean(usbDevice);
    }

    @Override
    public boolean prepareTransport() throws IchTransportException {
        return JUsbTransportCore.initMsdcScsi_Jni(this.deviceName);
    }

    @Override
    public boolean destroyTransport() throws IchTransportException {
        return JUsbTransportCore.release_Jni();
    }

    public int getCurrentMode() throws IchTransportException {
        return JUsbTransportMsdc.getCurrentMode_Jni();
    }

    public int switchToPreview() throws IchTransportException {
        return JUsbTransportMsdc.switchToPreview_Jni();
    }

    public int switchToPlayback() throws IchTransportException {
        return JUsbTransportMsdc.switchToPlayback_Jni();
    }

    public int executeScsiCommand(ICatchScsiCommandInfo commandInfo, byte[] buffer) throws IchInvalidArgumentException, IchTransportException, IchTryAgainException {
        if (commandInfo == null) {
            throw new IchInvalidArgumentException("Invalid argument, the command info should not be null.");
        }
        int dataLength = commandInfo.getDataLength();
        if (dataLength > 0 && buffer == null || dataLength > 0 && dataLength > buffer.length) {
            throw new IchInvalidArgumentException("Not enough buffer to hold transfer data.");
        }
        int retVal = JUsbTransportMsdc.executeScsiCommand_Jni(commandInfo, buffer);
        if (retVal == -200) {
            throw new IchTryAgainException("Wait resource timeout, please try again.");
        }
        return retVal;
    }
}

