/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.reliant.customer.type;

import org.json.JSONException;
import org.json.JSONObject;

public class ICatchAudioFormat {
    public static final int DEFAULT_AUDIO_STREAM_NO = 0;
    private int codec;
    private int frequency;
    private int nChannels;
    private int sampleBits;

    public ICatchAudioFormat() {
        this.codec = 144;
        this.frequency = 16000;
        this.nChannels = 1;
        this.sampleBits = 16;
    }

    public ICatchAudioFormat(int codec, int frequency, int nChannels, int sampleBits) {
        this.codec = codec;
        this.frequency = frequency;
        this.nChannels = nChannels;
        this.sampleBits = sampleBits;
    }

    public int getCodec() {
        return this.codec;
    }

    public void setCodec(int codec) {
        this.codec = codec;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getSampleBits() {
        return this.sampleBits;
    }

    public void setSampleBits(int sampleBits) {
        this.sampleBits = sampleBits;
    }

    public int getNChannels() {
        return this.nChannels;
    }

    public void setNChannels(int nChannels) {
        this.nChannels = nChannels;
    }

    public String toString() {
        JSONObject attributes = new JSONObject();
        try {
            attributes.put("codec", this.codec);
            attributes.put("frequency", this.frequency);
            attributes.put("nChannels", this.nChannels);
            attributes.put("sampleBits", this.sampleBits);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
        return attributes.toString();
    }

    public static ICatchAudioFormat fromString(String attributes) {
        int sampleBits;
        int nChannels;
        int frequency;
        int codec;
        try {
            JSONObject json = new JSONObject(attributes);
            codec = json.getInt("codec");
            frequency = json.getInt("frequency");
            nChannels = json.getInt("nChannels");
            sampleBits = json.getInt("sampleBits");
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
        ICatchAudioFormat audioFormat = new ICatchAudioFormat();
        audioFormat.setCodec(codec);
        audioFormat.setFrequency(frequency);
        audioFormat.setNChannels(nChannels);
        audioFormat.setSampleBits(sampleBits);
        return audioFormat;
    }
}

