/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.reliant.customer.type;

import com.icatchtek.reliant.customer.type.ICatchStreamParam;
import org.json.JSONException;
import org.json.JSONObject;

public class ICatchH264StreamParam
implements ICatchStreamParam {
    private int codec = 41;
    private int width;
    private int height;
    private int bitRate;
    private int frameRate;

    public ICatchH264StreamParam() {
        this.width = 1920;
        this.height = 960;
        this.bitRate = 5000000;
        this.frameRate = 30;
    }

    public ICatchH264StreamParam(int width, int height) {
        this.width = width;
        this.height = height;
        this.bitRate = 5000000;
        this.frameRate = 30;
    }

    public ICatchH264StreamParam(int width, int height, int frameRate) {
        this.width = width;
        this.height = height;
        this.bitRate = 5000000;
        this.frameRate = frameRate;
    }

    public ICatchH264StreamParam(int width, int height, int frameRate, int bitRate) {
        this.width = width;
        this.height = height;
        this.bitRate = bitRate;
        this.frameRate = frameRate;
    }

    @Override
    public int getTransportType() {
        return -1;
    }

    @Override
    public int getCodec() {
        return 41;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getBitRate() {
        return this.bitRate;
    }

    @Override
    public int getFrameRate() {
        return this.frameRate;
    }

    @Override
    public String getCmdLineParam() {
        StringBuilder builder = new StringBuilder();
        builder.append("H264?");
        builder.append("W=").append(this.width).append("&");
        builder.append("H=").append(this.height).append("&");
        builder.append("FPS=").append(this.frameRate).append("&");
        builder.append("BR=").append(this.bitRate);
        return builder.toString();
    }

    public String toString() {
        JSONObject attributes = new JSONObject();
        try {
            attributes.put("codecName", (Object)"H264");
            attributes.put("codec", this.codec);
            attributes.put("videoW", this.width);
            attributes.put("videoH", this.height);
            attributes.put("bitRate", this.bitRate);
            attributes.put("frameRate", this.frameRate);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
        return attributes.toString();
    }

    public static ICatchH264StreamParam fromString(String attributes) {
        int frameRate;
        int bitRate;
        int height;
        int width;
        try {
            JSONObject json = new JSONObject(attributes);
            String codec = json.getString("codecName");
            if (codec.equals("H264")) {
                return null;
            }
            width = json.getInt("videoW");
            height = json.getInt("videoH");
            bitRate = json.getInt("bitRate");
            frameRate = json.getInt("frameRate");
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
        return new ICatchH264StreamParam(width, height, frameRate, bitRate);
    }
}

