/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.util.Log;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class CoreMulticast {
    private static final int MULTI_CAST_PORT = 5002;
    private static final String MULTI_CAST_ADDR = "234.168.168.168";
    private MulticastSocket multicastSocket;
    private WifiManager.MulticastLock multicastLock;

    public boolean prepare(Context context) {
        InetAddress group;
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        this.multicastLock = wifiManager.createMulticastLock("multicast.test");
        this.multicastLock.acquire();
        try {
            this.multicastSocket = new MulticastSocket(5002);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            group = InetAddress.getByName(MULTI_CAST_ADDR);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            this.release();
            return false;
        }
        try {
            this.multicastSocket.joinGroup(group);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.release();
            return false;
        }
        try {
            this.multicastSocket.setSoTimeout(200);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.release();
            return false;
        }
        return true;
    }

    public void release() {
        if (this.multicastSocket != null) {
            this.multicastSocket.close();
            this.multicastSocket = null;
        }
        if (this.multicastLock != null) {
            this.multicastLock.release();
            this.multicastLock = null;
        }
    }

    public String receive() {
        byte[] buffer = new byte[256];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        try {
            this.multicastSocket.receive(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        String address = packet.getAddress().toString();
        String content = new String(packet.getData(), packet.getOffset(), packet.getLength());
        Log.i((String)"__multi_cast_recv__", (String)("address: " + address));
        Log.i((String)"__multi_cast_recv__", (String)("content: " + content));
        return content;
    }
}

