/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.feature;

import android.content.Context;
import android.util.Log;
import com.icatchtek.control.core.CoreLogger;
import com.icatchtek.control.core.CoreMulticast;
import com.icatchtek.control.core.jni.JCameraAssist;
import com.icatchtek.control.customer.ICatchCameraAssist;
import com.icatchtek.control.customer.ICatchCameraSession;
import com.icatchtek.control.customer.exception.IchCameraModeException;
import com.icatchtek.control.customer.exception.IchDevicePropException;
import com.icatchtek.reliant.customer.exception.IchDeviceException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchNotSupportedException;
import com.icatchtek.reliant.customer.exception.IchSocketException;
import com.icatchtek.reliant.customer.exception.IchTimeOutException;
import com.icatchtek.reliant.customer.transport.ICatchINETTransport;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCBulkTransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCIsoTransport;
import com.icatchtek.reliant.customer.transport.ICatchUsbScsiTransport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class ICatchCameraAssistImpl
extends ICatchCameraAssist {
    private static final int TRANSPORT_TYPE_NET_COMMON = 1;
    private static final int TRANSPORT_TYPE_UVC_ISO = 2;
    private static final int TRANSPORT_TYPE_UVC_BULK = 3;
    private static final int TRANSPORT_TYPE_MSDC_SCSI = 4;
    private int transportType;
    private String ipAddr;
    private int vendorID;
    private int productID;
    private int fileDescriptor;
    private byte[] __default_key = new byte[]{33, 126, 26, 22, 40, -34, -46, -89, -85, -25, -123, -120, 9, -54, 64, 60};
    private boolean tcpReceiverRun = false;
    private boolean receiverCanceled = true;
    private MulticastReceiver multicastReceiver = null;
    private boolean multicastReceiverRun = false;

    public ICatchCameraAssistImpl(ICatchITransport transport) {
        if (transport instanceof ICatchINETTransport) {
            this.transportType = 1;
            this.ipAddr = ((ICatchINETTransport)transport).getIpAddress();
        }
        if (transport instanceof ICatchUVCIsoTransport) {
            this.transportType = 2;
            this.vendorID = ((ICatchUVCIsoTransport)transport).getVendorID();
            this.productID = ((ICatchUVCIsoTransport)transport).getProductID();
            this.fileDescriptor = ((ICatchUVCIsoTransport)transport).getFileDescriptor();
        }
        if (transport instanceof ICatchUVCBulkTransport) {
            this.transportType = 3;
        }
        if (transport instanceof ICatchUsbScsiTransport) {
            this.transportType = 4;
        }
    }

    @Override
    public boolean loadLibrary(Context context, String libPath, String libName) {
        File libs_dir = context.getDir("libs", 0);
        Log.i((String)"libs_dir", (String)("absolute path: " + libs_dir.getAbsolutePath()));
        String new_file_name = libs_dir.getPath() + "/" + libName;
        String old_file_name = libPath + "/" + libName;
        if (!this.copyLibrary(new_file_name, old_file_name)) {
            return false;
        }
        try {
            System.load(new_file_name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyLibrary(String new_file_name, String old_file_name) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int dataSize;
            File new_file = new File(new_file_name);
            File old_file = new File(old_file_name);
            if (new_file.exists()) {
                new_file.delete();
            }
            fis = new FileInputStream(old_file);
            fos = new FileOutputStream(new_file);
            byte[] dataBuffer = new byte[2048];
            while ((dataSize = fis.read(dataBuffer)) != -1) {
                fos.write(dataBuffer, 0, dataSize);
            }
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean updateFw(ICatchCameraSession session, String fwFile) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException, IchTimeOutException, IchDeviceException, IchNotSupportedException {
        return JCameraAssist.updateFw_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor, session.getSessionID(), fwFile);
    }

    @Override
    public void notifyUpdateFw() {
        JCameraAssist.notifyUpdateFw_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor);
    }

    @Override
    public String simpleConfig(Context context, String essid, String passwd, String ipAddr, String macAddr) throws IchSocketException, IchTimeOutException, IchInvalidArgumentException {
        return this.simpleConfig(context, essid, passwd, ipAddr, macAddr, 180);
    }

    @Override
    public String simpleConfig(Context context, String essid, String passwd, String ipAddr, String macAddr, int timeout) throws IchSocketException, IchTimeOutException, IchInvalidArgumentException {
        return this.simpleConfig(context, essid, passwd, this.__default_key, ipAddr, macAddr, timeout);
    }

    @Override
    public String simpleConfig(Context context, String essid, String passwd, byte[] key, String ipAddr, String macAddr, int timeout) throws IchSocketException, IchTimeOutException, IchInvalidArgumentException {
        if (key == null || key.length != 16) {
            throw new IchInvalidArgumentException("The length of key must be 16.");
        }
        if (ipAddr == null || ipAddr.length() <= 0) {
            throw new IchInvalidArgumentException("No valid data in ipAddr.");
        }
        if (macAddr == null || macAddr.length() <= 0) {
            throw new IchInvalidArgumentException("No valid data in macAddr.");
        }
        if (!this.receiverCanceled || this.multicastReceiver != null && this.multicastReceiver.isAlive()) {
            throw new IchSocketException("Socket error, do you forget to stop previous simple config process.");
        }
        boolean retVal = JCameraAssist.simpleConfig_Jni(this.transportType, ipAddr, this.vendorID, this.productID, this.fileDescriptor, essid, passwd, key, ipAddr, macAddr, timeout);
        if (!retVal) {
            return null;
        }
        this.receiverCanceled = false;
        this.tcpReceiverRun = true;
        this.multicastReceiverRun = true;
        this.multicastReceiver = new MulticastReceiver(context, timeout);
        this.multicastReceiver.start();
        String content = null;
        long time = System.currentTimeMillis();
        while (System.currentTimeMillis() - time < (long)(timeout * 1000)) {
            if (this.tcpReceiverRun) {
                try {
                    content = JCameraAssist.simpleConfigGet_Jni(this.transportType, ipAddr, this.vendorID, this.productID, this.fileDescriptor);
                }
                catch (Exception ex) {
                    CoreLogger.logI("simple_config", "receive sock response: " + ex.getMessage());
                }
                if (content != null) {
                    this.simpleConfigCancel();
                    CoreLogger.logI("simple_config", "tcp sock receive content");
                    break;
                }
            }
            if (this.multicastReceiverRun && (content = this.multicastReceiver.getContent()) != null) {
                this.simpleConfigCancel();
                CoreLogger.logI("simple_config", "multi cast sock receive content");
                break;
            }
            if (this.receiverCanceled || !this.tcpReceiverRun && !this.multicastReceiverRun) {
                CoreLogger.logI("simple_config", "loop control flag break.");
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        CoreLogger.logI("simple_config", "timeout: " + timeout * 1000 + ", passed: " + (System.currentTimeMillis() - time));
        this.tcpReceiverRun = false;
        this.receiverCanceled = true;
        this.multicastReceiverRun = false;
        try {
            this.multicastReceiver.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (content == null) {
            throw new IchTimeOutException("Timeout to receive camera's content");
        }
        return content;
    }

    @Override
    public boolean simpleConfigCancel() {
        this.tcpReceiverRun = false;
        this.multicastReceiverRun = false;
        try {
            this.multicastReceiver.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.receiverCanceled = true;
        return JCameraAssist.simpleConfigCancel_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor);
    }

    @Override
    public boolean startDeviceScan() {
        return JCameraAssist.startDeviceScan_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor);
    }

    @Override
    public boolean stopDeviceScan() {
        return JCameraAssist.stopDeviceScan_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor);
    }

    @Override
    public boolean deviceInit(String ipAddr) {
        return JCameraAssist.deviceInit_Jni(this.transportType, ipAddr, this.vendorID, this.productID, this.fileDescriptor, ipAddr);
    }

    @Override
    public boolean wakeUpCamera(String macAddress) throws IchSocketException, IchInvalidArgumentException {
        return JCameraAssist.wakeUpCamera_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor, macAddress);
    }

    private class MulticastReceiver
    extends Thread {
        private int timeout;
        private String content;
        private Context context;
        private CoreMulticast multicast;

        public MulticastReceiver(Context context, int timeout) {
            this.context = context;
            this.timeout = timeout;
            this.multicast = new CoreMulticast();
        }

        public String getContent() {
            return this.content;
        }

        @Override
        public void run() {
            this.multicast.prepare(this.context);
            long time = System.currentTimeMillis();
            while (ICatchCameraAssistImpl.this.multicastReceiverRun && System.currentTimeMillis() - time < (long)(this.timeout * 1000)) {
                this.content = this.multicast.receive();
                if (this.content != null) {
                    Log.i((String)"multicast.receive", (String)("received content: " + this.content));
                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.multicast.release();
        }
    }
}

