/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.feature;

import com.icatchtek.control.core.jni.JCameraConfig;
import com.icatchtek.control.customer.ICatchCameraConfig;
import com.icatchtek.reliant.customer.transport.ICatchINETTransport;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCBulkTransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCIsoTransport;
import com.icatchtek.reliant.customer.transport.ICatchUsbScsiTransport;

public class ICatchCameraConfigImpl
implements ICatchCameraConfig {
    private static final int TRANSPORT_TYPE_NET_COMMON = 1;
    private static final int TRANSPORT_TYPE_UVC_ISO = 2;
    private static final int TRANSPORT_TYPE_UVC_BULK = 3;
    private static final int TRANSPORT_TYPE_MSDC_SCSI = 4;
    private int transportType;
    private String ipAddr;
    private int vendorID;
    private int productID;
    private int fileDescriptor;

    public ICatchCameraConfigImpl(ICatchITransport transport) {
        if (transport instanceof ICatchINETTransport) {
            this.transportType = 1;
            this.ipAddr = ((ICatchINETTransport)transport).getIpAddress();
        }
        if (transport instanceof ICatchUVCIsoTransport) {
            this.transportType = 2;
            this.vendorID = ((ICatchUVCIsoTransport)transport).getVendorID();
            this.productID = ((ICatchUVCIsoTransport)transport).getProductID();
            this.fileDescriptor = ((ICatchUVCIsoTransport)transport).getFileDescriptor();
        }
        if (transport instanceof ICatchUVCBulkTransport) {
            this.transportType = 3;
        }
        if (transport instanceof ICatchUsbScsiTransport) {
            this.transportType = 4;
        }
    }

    @Override
    public boolean setConnectionCheckParam(int ptpTimeoutCheckCount) {
        return JCameraConfig.setConnectionCheckParam_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor, ptpTimeoutCheckCount, ptpTimeoutCheckCount);
    }

    @Override
    public boolean setConnectionCheckParam(int ptpTimeoutCheckCount, double ptpTimeoutCheckIntervalInSecs, int rtpTimeoutInSecs) {
        return JCameraConfig.setConnectionCheckParam_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor, ptpTimeoutCheckCount, ptpTimeoutCheckIntervalInSecs, ptpTimeoutCheckCount);
    }

    @Override
    public int getPtpTimeoutCheckCount() {
        return JCameraConfig.getPtpTimeoutCheckCount_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor);
    }

    @Override
    public double getPtpTimeoutCheckIntervalInSecs() {
        return JCameraConfig.getPtpTimeoutCheckIntervalInSecs_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor);
    }

    @Override
    public boolean enablePTPIP() {
        return JCameraConfig.enablePTPIP_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor);
    }

    @Override
    public boolean disablePTPIP() {
        return JCameraConfig.disablePTPIP_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor);
    }

    @Override
    public boolean enableSocketIO() {
        return JCameraConfig.enableSocketIO_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor);
    }

    @Override
    public boolean disableSocketIO() {
        return JCameraConfig.disableSocketIO_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor);
    }

    @Override
    public boolean enablePTPReconnection(boolean enable) {
        return JCameraConfig.enablePtpReconnect_Jni(this.transportType, this.ipAddr, this.vendorID, this.productID, this.fileDescriptor, enable);
    }
}

