/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.feature;

import com.icatchtek.control.core.jni.JCameraControl;
import com.icatchtek.control.core.jni.util.DataTypeUtil;
import com.icatchtek.control.core.util.event.CoreEventListener;
import com.icatchtek.control.customer.ICatchCameraControl;
import com.icatchtek.control.customer.ICatchCameraListener;
import com.icatchtek.control.customer.exception.IchCameraModeException;
import com.icatchtek.control.customer.exception.IchCaptureImageException;
import com.icatchtek.control.customer.exception.IchDevicePropException;
import com.icatchtek.control.customer.exception.IchNoSDCardException;
import com.icatchtek.control.customer.exception.IchStorageFormatException;
import com.icatchtek.control.customer.type.ICatchCamVideoRecordStatus;
import com.icatchtek.reliant.customer.exception.IchDeviceException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchListenerExistsException;
import com.icatchtek.reliant.customer.exception.IchListenerNotExistsException;
import com.icatchtek.reliant.customer.exception.IchSocketException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.transport.ICatchINETTransport;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import com.icatchtek.reliant.customer.type.ICatchFile;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class ICatchCameraControlImpl
implements ICatchCameraControl {
    private int sessionID;
    private ICatchITransport transport;

    public ICatchCameraControlImpl(int sessionID, ICatchITransport transport) {
        this.sessionID = sessionID;
        this.transport = transport;
    }

    @Override
    public List<Integer> getSupportedModes() throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        String modesStr = JCameraControl.getSupportedModes_Jni(this.sessionID);
        return DataTypeUtil.splitStringToIntList(modesStr);
    }

    @Override
    public int getCurrentCameraMode() {
        return JCameraControl.getCurrentCameraMode_Jni(this.sessionID);
    }

    @Override
    public boolean changePreviewMode(int PreviewMode) throws IchCameraModeException {
        return JCameraControl.changePreviewMode_Jni(this.sessionID, PreviewMode);
    }

    @Override
    public boolean startTimeLapse() throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        return JCameraControl.startTimeLapse_Jni(this.sessionID);
    }

    @Override
    public boolean stopTimeLapse() throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        return JCameraControl.stopTimeLapse_Jni(this.sessionID);
    }

    @Override
    public int getCurrentBatteryLevel() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraControl.getCurrentBatteryLevel_Jni(this.sessionID);
    }

    @Override
    public boolean isSDCardExist() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDeviceException {
        return JCameraControl.isSDCardExist_Jni(this.sessionID);
    }

    @Override
    public int getFreeSpaceInImages() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchNoSDCardException, IchDevicePropException {
        return JCameraControl.getFreeSpaceInImages_Jni(this.sessionID);
    }

    @Override
    public int getRemainRecordingTime() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchNoSDCardException, IchInvalidSessionException {
        return JCameraControl.getRemainRecordingTime_Jni(this.sessionID);
    }

    @Override
    public boolean supportVideoPlayback() throws IchDevicePropException, IchNoSDCardException, IchSocketException, IchCameraModeException, IchInvalidSessionException {
        return JCameraControl.supportedVideoPlayback_Jni(this.sessionID);
    }

    @Override
    public int startMovieRecord() throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        int retVal = JCameraControl.startMovieRecord_Jni(this.sessionID);
        return retVal;
    }

    @Override
    public int stopMovieRecord() throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        int retVal = JCameraControl.stopMovieRecord_Jni(this.sessionID);
        return retVal;
    }

    @Override
    public boolean capturePhoto() throws IchCaptureImageException, IchTryAgainException, IchSocketException, IchCameraModeException, IchInvalidSessionException {
        return JCameraControl.capturePhoto_Jni(this.sessionID);
    }

    @Override
    public boolean capturePhoto(int timeoutInSecs) throws IchCaptureImageException, IchSocketException, IchCameraModeException, IchInvalidSessionException {
        return JCameraControl.capturePhoto_Jni(this.sessionID, timeoutInSecs);
    }

    @Override
    public boolean triggerCapturePhoto() throws IchCaptureImageException, IchSocketException, IchCameraModeException, IchInvalidSessionException {
        return JCameraControl.triggerCapturePhoto_Jni(this.sessionID);
    }

    @Override
    public int formatStorage() throws IchSocketException, IchCameraModeException, IchStorageFormatException, IchInvalidSessionException {
        return JCameraControl.formatStorage_Jni(this.sessionID);
    }

    @Override
    public int formatStorage(int timeoutInSecs) throws IchSocketException, IchCameraModeException, IchStorageFormatException, IchInvalidSessionException {
        return JCameraControl.formatStorage_Jni(this.sessionID, timeoutInSecs);
    }

    @Override
    public boolean setAudioMute() throws IchSocketException, IchCameraModeException, IchStorageFormatException, IchInvalidSessionException {
        return JCameraControl.setAudioMute_Jni(this.sessionID);
    }

    @Override
    public boolean setAudioUnMute() throws IchSocketException, IchCameraModeException, IchStorageFormatException, IchInvalidSessionException {
        return JCameraControl.setAudioUnMute_Jni(this.sessionID);
    }

    @Override
    public boolean setEventTrigger() throws IchSocketException, IchCameraModeException, IchStorageFormatException, IchInvalidSessionException {
        return JCameraControl.setEventTrigger_Jni(this.sessionID);
    }

    @Override
    public ICatchCamVideoRecordStatus getVideoRecordStatus() throws IchSocketException, IchCameraModeException, IchStorageFormatException, IchInvalidSessionException {
        String attribute = JCameraControl.getVideoRecordStatus_Jni(this.sessionID);
        if (attribute == null) {
            return null;
        }
        return ICatchCamVideoRecordStatus.fromString(attribute);
    }

    @Override
    public boolean zoomIn() throws IchSocketException, IchCameraModeException, IchStorageFormatException, IchInvalidSessionException {
        return JCameraControl.zoomIn_Jni(this.sessionID);
    }

    @Override
    public boolean zoomOut() throws IchSocketException, IchCameraModeException, IchStorageFormatException, IchInvalidSessionException {
        return JCameraControl.zoomOut_Jni(this.sessionID);
    }

    @Override
    public boolean pan(int xshift, int yshfit) {
        return JCameraControl.pan_Jni(this.sessionID, xshift, yshfit);
    }

    @Override
    public boolean panReset() {
        return JCameraControl.panReset_Jni(this.sessionID);
    }

    @Override
    public boolean toStandbyMode() throws IchSocketException, IchDeviceException, IchInvalidSessionException {
        return JCameraControl.toStandbyMode_Jni(this.sessionID);
    }

    @Override
    public boolean setFileProtection(ICatchFile file, int newprot) throws IchSocketException, IchDeviceException, IchInvalidSessionException {
        return JCameraControl.setFileProtection_Jni(this.sessionID, file, newprot);
    }

    @Override
    public String getMacAddress() {
        if (this.transport instanceof ICatchINETTransport) {
            ICatchINETTransport inetTransport = (ICatchINETTransport)this.transport;
            String line = this.getMatchedLineFromArpCache(inetTransport.getIpAddress());
            if (line == null) {
                return null;
            }
            String[] attributes = line.split("\\s+");
            if (attributes.length < 3) {
                return null;
            }
            return attributes[3];
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMatchedLineFromArpCache(String ipAddress) {
        String line = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader("/proc/net/arp"));
            while ((line = reader.readLine()) != null && !line.contains(ipAddress)) {
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return line;
    }

    @Override
    public boolean addEventListener(int eventID, ICatchCameraListener listener) throws IchListenerExistsException, IchInvalidSessionException {
        CoreEventListener coreEventListener = new CoreEventListener(listener);
        return JCameraControl.addEventListener_Jni(this.sessionID, eventID, coreEventListener, listener.hashCode());
    }

    @Override
    public boolean delEventListener(int eventID, ICatchCameraListener listener) throws IchListenerNotExistsException, IchInvalidSessionException {
        return JCameraControl.removeEventListener_Jni(this.sessionID, eventID, listener.hashCode());
    }

    @Override
    public boolean addCustomEventListener(int eventID, ICatchCameraListener listener) throws IchListenerExistsException, IchInvalidSessionException {
        CoreEventListener coreEventListener = new CoreEventListener(listener);
        return JCameraControl.addCustomEventListener_Jni(this.sessionID, eventID, coreEventListener, listener.hashCode());
    }

    @Override
    public boolean delCustomEventListener(int eventID, ICatchCameraListener listener) throws IchListenerNotExistsException, IchInvalidSessionException {
        return JCameraControl.removeCustomEventListener_Jni(this.sessionID, eventID, listener.hashCode());
    }
}

