/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.feature;

import com.icatchtek.control.core.jni.JCameraPlayback;
import com.icatchtek.control.core.util.type.NativeFile;
import com.icatchtek.control.customer.ICatchCameraPlayback;
import com.icatchtek.control.customer.exception.IchCameraModeException;
import com.icatchtek.control.customer.exception.IchNoSuchPathException;
import com.icatchtek.reliant.customer.exception.IchBufferTooSmallException;
import com.icatchtek.reliant.customer.exception.IchDeviceException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchNoSuchFileException;
import com.icatchtek.reliant.customer.exception.IchSocketException;
import com.icatchtek.reliant.customer.type.ICatchFile;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;
import java.util.List;

public class ICatchCameraPlaybackImpl
implements ICatchCameraPlayback {
    private int sessionID;

    public ICatchCameraPlaybackImpl(int sessionID) {
        this.sessionID = sessionID;
    }

    @Override
    public boolean setFileListAttribute(int type, int order) throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        return this.setFileListAttribute(type, order, 0);
    }

    @Override
    public boolean setFileListAttribute(int type, int order, int takenBy) throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        return JCameraPlayback.setFileListAttribute_Jni(this.sessionID, type, order, takenBy);
    }

    @Override
    public int getFileCount() throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        return JCameraPlayback.getFileCount_Jni(this.sessionID);
    }

    @Override
    public List<ICatchFile> listFiles(int fileType) throws IchSocketException, IchCameraModeException, IchNoSuchPathException, IchInvalidSessionException {
        String files = JCameraPlayback.listFiles_Jni(this.sessionID, fileType);
        return NativeFile.toIcatchFiles(files);
    }

    @Override
    public List<ICatchFile> listFiles(int fileType, int timeoutInSecs) throws IchSocketException, IchCameraModeException, IchNoSuchPathException, IchInvalidSessionException {
        String files = JCameraPlayback.listFiles_Jni(this.sessionID, fileType, timeoutInSecs);
        return NativeFile.toIcatchFiles(files);
    }

    @Override
    public List<ICatchFile> listFiles(int fileType, int headIndex, int tailIndex, int timeoutInSecs) throws IchSocketException, IchCameraModeException, IchNoSuchPathException, IchInvalidSessionException, IchInvalidArgumentException {
        String files = JCameraPlayback.listFiles_Jni(this.sessionID, fileType, headIndex, tailIndex, timeoutInSecs);
        return NativeFile.toIcatchFiles(files);
    }

    @Override
    public boolean openFileTransChannel() throws IchSocketException, IchInvalidSessionException {
        return JCameraPlayback.openFileTransChannel_Jni(this.sessionID);
    }

    @Override
    public boolean downloadFileQuick(ICatchFile file, String path) throws IchNoSuchFileException, IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDeviceException {
        String icatchFile = NativeFile.toICatchFile(file);
        return JCameraPlayback.downloadFileQuick_Jni(this.sessionID, icatchFile, path);
    }

    @Override
    public boolean closeFileTransChannel() throws IchSocketException, IchInvalidSessionException {
        return JCameraPlayback.closeFileTransChannel_Jni(this.sessionID);
    }

    @Override
    public ICatchFrameBuffer downloadFile(ICatchFile file) throws IchNoSuchFileException, IchSocketException, IchCameraModeException, IchBufferTooSmallException, IchInvalidSessionException, IchDeviceException {
        int bufferSize = 9980928;
        ICatchFrameBuffer buffer = new ICatchFrameBuffer(bufferSize);
        String icatchFile = NativeFile.toICatchFile(file);
        while (true) {
            try {
                int dataSize = JCameraPlayback.downloadImage_Jni(this.sessionID, icatchFile, buffer.getBuffer());
                buffer.setFrameSize(dataSize);
            }
            catch (IchBufferTooSmallException ex) {
                buffer = new ICatchFrameBuffer(bufferSize += 0x100000);
                continue;
            }
            break;
        }
        return buffer;
    }

    @Override
    public boolean uploadFile(String localPath, String remotePath) throws IchNoSuchFileException, IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDeviceException {
        return JCameraPlayback.uploadFile_Jni(this.sessionID, localPath, remotePath);
    }

    @Override
    public boolean uploadFileQuick(String localPath, String remotePath) throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDeviceException {
        return JCameraPlayback.uploadFileQuick_Jni(this.sessionID, localPath, remotePath);
    }

    @Override
    public boolean cancelFileDownload() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDeviceException {
        return JCameraPlayback.cancelFileDownload_Jni(this.sessionID);
    }

    @Override
    public boolean downloadFile(ICatchFile file, String path) throws IchNoSuchFileException, IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDeviceException {
        String icatchFile = NativeFile.toICatchFile(file);
        return JCameraPlayback.downloadFile_Jni(this.sessionID, icatchFile, path);
    }

    @Override
    public boolean downloadFile(String srcPath, String dstPath) throws IchNoSuchFileException, IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDeviceException {
        return JCameraPlayback.downloadFile1_Jni(this.sessionID, srcPath, dstPath);
    }

    @Override
    public boolean deleteFile(ICatchFile file) throws IchNoSuchFileException, IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDeviceException {
        String icatchFile = NativeFile.toICatchFile(file);
        return JCameraPlayback.deleteFile_Jni(this.sessionID, icatchFile);
    }

    @Override
    public ICatchFrameBuffer getThumbnail(ICatchFile file) throws IchNoSuchFileException, IchSocketException, IchCameraModeException, IchBufferTooSmallException, IchInvalidSessionException, IchDeviceException {
        ICatchFrameBuffer buffer = new ICatchFrameBuffer(0xA00000);
        String icatchFile = NativeFile.toICatchFile(file);
        int dataSize = JCameraPlayback.getThumbnail_Jni(this.sessionID, icatchFile, buffer.getBuffer());
        buffer.setFrameSize(dataSize);
        return buffer;
    }

    @Override
    public ICatchFrameBuffer getQuickview(ICatchFile file) throws IchNoSuchFileException, IchSocketException, IchCameraModeException, IchBufferTooSmallException, IchInvalidSessionException, IchDeviceException {
        ICatchFrameBuffer buffer = new ICatchFrameBuffer(1843200);
        String icatchFile = NativeFile.toICatchFile(file);
        int dataSize = JCameraPlayback.getQuickView_Jni(this.sessionID, icatchFile, buffer.getBuffer());
        buffer.setFrameSize(dataSize);
        return buffer;
    }
}

