/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.feature;

import com.icatchtek.control.core.jni.JCameraProperty;
import com.icatchtek.control.core.jni.util.DataTypeUtil;
import com.icatchtek.control.customer.ICatchCameraProperty;
import com.icatchtek.control.customer.exception.IchCameraModeException;
import com.icatchtek.control.customer.exception.IchDevicePropException;
import com.icatchtek.control.customer.type.ICatchCamByteArray;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchOutOfMemoryException;
import com.icatchtek.reliant.customer.exception.IchSocketException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;
import java.util.List;

public class ICatchCameraPropertyImpl
implements ICatchCameraProperty {
    private int sessionID;

    public ICatchCameraPropertyImpl(int sessionID) {
        this.sessionID = sessionID;
    }

    @Override
    public boolean setPropertyValue(int propId, int value) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        return JCameraProperty.setNumericPropertyValue_Jni(this.sessionID, propId, value);
    }

    @Override
    public boolean setPropertyValue(int propId, int value, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        return JCameraProperty.setNumericPropertyValue_Jni(this.sessionID, propId, value, timeoutInSecs);
    }

    @Override
    public int getCurrentPropertyValue(int propId) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException, IchTryAgainException {
        return JCameraProperty.getCurrentNumericPropertyValue_Jni(this.sessionID, propId);
    }

    @Override
    public int getCurrentPropertyValue(int propId, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        return JCameraProperty.getCurrentNumericPropertyValue_Jni(this.sessionID, propId, timeoutInSecs);
    }

    @Override
    public boolean setProperty(int cmd, byte[] data, int dataSize) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        return JCameraProperty.setProperty_Jni(this.sessionID, cmd, data, dataSize);
    }

    @Override
    public int getProperty(int cmd, byte[] data) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        return JCameraProperty.getProperty_Jni(this.sessionID, cmd, data);
    }

    @Override
    public List<Integer> getSupportedPropertyValues(int propId) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String propValue = JCameraProperty.getSupportedNumericPropertyValues_Jni(this.sessionID, propId);
        return DataTypeUtil.splitStringToIntList(propValue);
    }

    @Override
    public List<Integer> getSupportedPropertyValues(int propId, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String propValue = JCameraProperty.getSupportedNumericPropertyValues_Jni(this.sessionID, propId, timeoutInSecs);
        return DataTypeUtil.splitStringToIntList(propValue);
    }

    @Override
    public boolean setStringPropertyValue(int propId, String value) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        return JCameraProperty.setStringPropertyValue_Jni(this.sessionID, propId, value);
    }

    @Override
    public boolean setStringPropertyValue(int propId, String value, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        return JCameraProperty.setStringPropertyValue_Jni(this.sessionID, propId, value, timeoutInSecs);
    }

    @Override
    public String getCurrentStringPropertyValue(int propId) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        return JCameraProperty.getCurrentStringPropertyValue_Jni(this.sessionID, propId);
    }

    @Override
    public String getCurrentStringPropertyValue(int propId, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        return JCameraProperty.getCurrentStringPropertyValue_Jni(this.sessionID, propId, timeoutInSecs);
    }

    @Override
    public List<String> getSupportedStringPropertyValues(int propId) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String propValue = JCameraProperty.getSupportedStringPropertyValues_Jni(this.sessionID, propId);
        return DataTypeUtil.splitStringToStringList(propValue);
    }

    @Override
    public List<String> getSupportedStringPropertyValues(int propId, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String propValue = JCameraProperty.getSupportedStringPropertyValues_Jni(this.sessionID, propId, timeoutInSecs);
        return DataTypeUtil.splitStringToStringList(propValue);
    }

    @Override
    public boolean setByteArrayPropertyValue(int propId, ICatchCamByteArray byteArray, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        return JCameraProperty.setByteArrayPropertyValue_Jni(this.sessionID, propId, byteArray, timeoutInSecs);
    }

    @Override
    public ICatchCamByteArray getCurrentByteArrayPropertyValue(int propId, int objectPropCode, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException, IchOutOfMemoryException {
        byte[] byteValue = new byte[1024];
        int dataSize = JCameraProperty.getCurrentByteArrayPropertyValue_Jni(this.sessionID, propId, byteValue, timeoutInSecs);
        if (dataSize <= 0) {
            return null;
        }
        return new ICatchCamByteArray(byteValue, dataSize);
    }

    @Override
    public boolean setLightFrequency(int value) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setLightFrequency_Jni(this.sessionID, value);
    }

    @Override
    public List<Integer> getSupportedLightFrequencies() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        String fmtValStr = JCameraProperty.getSupportedLightFrequencies_Jni(this.sessionID);
        return DataTypeUtil.splitStringToIntList(fmtValStr);
    }

    @Override
    public int getCurrentLightFrequency() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentLightFrequency_Jni(this.sessionID);
    }

    @Override
    public boolean setWhiteBalance(int value) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setWhiteBalance_Jni(this.sessionID, value);
    }

    @Override
    public List<Integer> getSupportedWhiteBalances() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        String fmtValStr = JCameraProperty.getSupportedWhiteBalances_Jni(this.sessionID);
        return DataTypeUtil.splitStringToIntList(fmtValStr);
    }

    @Override
    public int getCurrentWhiteBalance() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentWhiteBalance_Jni(this.sessionID);
    }

    @Override
    public boolean setCaptureDelay(int value) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setCaptureDelay_Jni(this.sessionID, value);
    }

    @Override
    public List<Integer> getSupportedCaptureDelays() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        String fmtValStr = JCameraProperty.getSupportedCaptureDelays_Jni(this.sessionID);
        return DataTypeUtil.splitStringToIntList(fmtValStr);
    }

    @Override
    public int getCurrentCaptureDelay() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentCaptureDelay_Jni(this.sessionID);
    }

    @Override
    public boolean setImageSize(String value) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setImageSize_Jni(this.sessionID, value);
    }

    @Override
    public List<String> getSupportedImageSizes() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        String fmtValStr = JCameraProperty.getSupportedImageSizes_Jni(this.sessionID);
        return DataTypeUtil.splitStringToStringList(fmtValStr);
    }

    @Override
    public String getCurrentImageSize() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentImageSize_Jni(this.sessionID);
    }

    @Override
    public boolean setVideoSize(String value) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setVideoSize_Jni(this.sessionID, value);
    }

    @Override
    public List<String> getSupportedVideoSizes() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        String fmtValStr = JCameraProperty.getSupportedVideoSizes_Jni(this.sessionID);
        return DataTypeUtil.splitStringToStringList(fmtValStr);
    }

    @Override
    public String getCurrentVideoSize() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentVideoSize_Jni(this.sessionID);
    }

    @Override
    public boolean setBurstNumber(int value) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setBurstNumber_Jni(this.sessionID, value);
    }

    @Override
    public List<Integer> getSupportedBurstNumbers() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        String fmtValStr = JCameraProperty.getSupportedBurstNumbers_Jni(this.sessionID);
        return DataTypeUtil.splitStringToIntList(fmtValStr);
    }

    @Override
    public int getCurrentBurstNumber() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentBurstNumber_Jni(this.sessionID);
    }

    @Override
    public boolean setDateStamp(int timestamp) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setDateStamp_Jni(this.sessionID, timestamp);
    }

    @Override
    public List<Integer> getSupportedDateStamps() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String fmtValStr = JCameraProperty.getSupportedDateStamps_Jni(this.sessionID);
        return DataTypeUtil.splitStringToIntList(fmtValStr);
    }

    @Override
    public int getCurrentDateStamp() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentDateStamp_Jni(this.sessionID);
    }

    @Override
    public List<Integer> getSupportedTimeLapseIntervals() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String fmtValStr = JCameraProperty.getSupportedTimeLapseIntervals_Jni(this.sessionID);
        return DataTypeUtil.splitStringToIntList(fmtValStr);
    }

    @Override
    public boolean setTimeLapseInterval(int stillInterval) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setTimeLapseInterval_Jni(this.sessionID, stillInterval);
    }

    @Override
    public int getCurrentTimeLapseInterval() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentTimeLapseInterval_Jni(this.sessionID);
    }

    @Override
    public List<Integer> getSupportedTimeLapseDurations() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String fmtValStr = JCameraProperty.getSupportedTimeLapseDurations_Jni(this.sessionID);
        return DataTypeUtil.splitStringToIntList(fmtValStr);
    }

    @Override
    public boolean setTimeLapseDuration(int stillDuration) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setTimeLapseDuration_Jni(this.sessionID, stillDuration);
    }

    @Override
    public int getCurrentTimeLapseDuration() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentTimeLapseDuration_Jni(this.sessionID);
    }

    @Override
    public int getCurrentUpsideDown() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentUpsideDown_Jni(this.sessionID);
    }

    @Override
    public boolean setUpsideDown(int usd) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setUpsideDown_Jni(this.sessionID, usd);
    }

    @Override
    public int getCurrentSlowMotion() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentSlowMotion_Jni(this.sessionID);
    }

    @Override
    public boolean setSlowMotion(int sm) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setSlowMotion_Jni(this.sessionID, sm);
    }

    @Override
    public int getMaxZoomRatio() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getMaxZoomRatio_Jni(this.sessionID);
    }

    @Override
    public int getCurrentZoomRatio() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentZoomRatio_Jni(this.sessionID);
    }

    @Override
    public List<Integer> getSupportedProperties() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        String fmtValStr = JCameraProperty.getSupportedCapabilities_Jni(this.sessionID);
        return DataTypeUtil.splitStringToIntList(fmtValStr);
    }

    @Override
    public boolean setSeamless(int value) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.setSeamless_Jni(this.sessionID, value);
    }

    @Override
    public List<Integer> getSupportedSeamlesses() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        String fmtValStr = JCameraProperty.getSupportedSeamlesses_Jni(this.sessionID);
        return DataTypeUtil.splitStringToIntList(fmtValStr);
    }

    @Override
    public int getCurrentSeamless() throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        return JCameraProperty.getCurrentSeamless_Jni(this.sessionID);
    }

    @Override
    public List<ICatchVideoFormat> getSupportedStreamingInfos() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        String fmtValStr = JCameraProperty.getSupportedStreamingInfos_Jni(this.sessionID);
        return DataTypeUtil.splitStringToVideoFormatList(fmtValStr);
    }

    @Override
    public ICatchVideoFormat getCurrentStreamingInfo() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        String fmtValStr = JCameraProperty.getCurrentStreamingInfo_Jni(this.sessionID);
        return DataTypeUtil.toVideoFormat(fmtValStr);
    }

    @Override
    public boolean setStreamingInfo(ICatchVideoFormat info) throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        if (info == null) {
            return false;
        }
        String videoInfo = DataTypeUtil.toVideoFormat(info);
        return JCameraProperty.setStreamingInfo_Jni(this.sessionID, videoInfo);
    }

    @Override
    public int getPreviewCacheTime() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        return JCameraProperty.getPreviewCacheTime_Jni(this.sessionID);
    }

    @Override
    public int getNumberOfSensors() throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        return JCameraProperty.getNumberOfSensors_Jni(this.sessionID);
    }

    @Override
    public boolean checkCameraCapabilities(int featureID) throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDevicePropException {
        return JCameraProperty.checkCameraCapabilities_Jni(this.sessionID, featureID);
    }
}

