/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.feature;

import com.icatchtek.control.core.feature.ICatchCameraAssistImpl;
import com.icatchtek.control.core.feature.ICatchCameraConfigImpl;
import com.icatchtek.control.customer.ICatchCameraAssist;
import com.icatchtek.control.customer.ICatchCameraConfig;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.transport.ICatchINETTransport;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCBulkTransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCIsoTransport;
import com.icatchtek.reliant.customer.transport.ICatchUsbScsiTransport;

public class ICatchSingletonFactory {
    private ICatchCameraConfig cameraConfigNet;
    private ICatchCameraAssist cameraAssistNet;
    private ICatchCameraConfig cameraConfigUsb;
    private ICatchCameraAssist cameraAssistUsb;
    private static ICatchSingletonFactory singletonFactory = new ICatchSingletonFactory();

    public static ICatchSingletonFactory getInstance() {
        return singletonFactory;
    }

    public synchronized ICatchCameraConfig getCameraConfig(ICatchITransport transport) throws IchInvalidArgumentException {
        if (transport == null) {
            throw new IchInvalidArgumentException("Transport should not be null.");
        }
        if (transport instanceof ICatchUsbScsiTransport || transport instanceof ICatchUVCBulkTransport || transport instanceof ICatchUVCIsoTransport) {
            if (this.cameraConfigUsb == null) {
                this.cameraConfigUsb = new ICatchCameraConfigImpl(transport);
            }
            return this.cameraConfigUsb;
        }
        if (transport instanceof ICatchINETTransport) {
            if (this.cameraConfigNet == null) {
                this.cameraConfigNet = new ICatchCameraConfigImpl(transport);
            }
            return this.cameraConfigNet;
        }
        throw new IchInvalidArgumentException("Transport Not supported.");
    }

    public synchronized ICatchCameraAssist getCameraAssist(ICatchITransport transport) throws IchInvalidArgumentException {
        if (transport == null) {
            throw new IchInvalidArgumentException("Transport should not be null.");
        }
        if (transport instanceof ICatchUsbScsiTransport || transport instanceof ICatchUVCBulkTransport || transport instanceof ICatchUVCIsoTransport) {
            if (this.cameraAssistUsb == null) {
                this.cameraAssistUsb = new ICatchCameraAssistImpl(transport);
            }
            return this.cameraAssistUsb;
        }
        if (transport instanceof ICatchINETTransport) {
            if (this.cameraAssistNet == null) {
                this.cameraAssistNet = new ICatchCameraAssistImpl(transport);
            }
            return this.cameraAssistNet;
        }
        throw new IchInvalidArgumentException("Transport Not supported.");
    }

    private ICatchSingletonFactory() {
    }
}

