/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.jni;

import com.icatchtek.control.core.jni.extractor.NativeValueExtractor;
import com.icatchtek.control.core.jni.util.NativeLibraryLoader;
import com.icatchtek.control.core.util.event.CoreEventListener;
import com.icatchtek.control.customer.exception.IchCameraModeException;
import com.icatchtek.control.customer.exception.IchCaptureImageException;
import com.icatchtek.control.customer.exception.IchDevicePropException;
import com.icatchtek.control.customer.exception.IchNoSDCardException;
import com.icatchtek.control.customer.exception.IchStorageFormatException;
import com.icatchtek.reliant.customer.exception.IchDeviceException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchListenerExistsException;
import com.icatchtek.reliant.customer.exception.IchListenerNotExistsException;
import com.icatchtek.reliant.customer.exception.IchSocketException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.exception.IchUnknownException;
import com.icatchtek.reliant.customer.type.ICatchFile;

public class JCameraControl {
    public static String getSupportedModes_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        String content = JCameraControl.getSupportedModes(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getCurrentCameraMode_Jni(int sessionID) {
        String content = JCameraControl.getCurrentCameraMode(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 65471;
        }
    }

    public static boolean changePreviewMode_Jni(int sessionID, int previewMode) throws IchCameraModeException {
        String content = JCameraControl.changePreviewMode(sessionID, previewMode);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean startTimeLapse_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        String content = JCameraControl.startTimeLapse(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean stopTimeLapse_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        String content = JCameraControl.stopTimeLapse(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getCurrentBatteryLevel_Jni(int sessionID) throws IchSocketException, IchInvalidSessionException, IchCameraModeException, IchDevicePropException {
        String content = JCameraControl.getCurrentBatteryLevel(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int startMovieRecord_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        String content = JCameraControl.startMovieRecord(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchUnknownException ex) {
            return ex.getExceptionID();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int stopMovieRecord_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchInvalidSessionException {
        String content = JCameraControl.stopMovieRecord(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchUnknownException ex) {
            return ex.getExceptionID();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean capturePhoto_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchTryAgainException, IchCameraModeException, IchCaptureImageException {
        String content = JCameraControl.capturePhotoA(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchTryAgainException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchCaptureImageException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean capturePhoto_Jni(int sessionID, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchCaptureImageException {
        String content = JCameraControl.capturePhotoB(sessionID, timeoutInSecs);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchCaptureImageException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean triggerCapturePhoto_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchCaptureImageException {
        String content = JCameraControl.triggerCapturePhoto(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchCaptureImageException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int formatStorage_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchStorageFormatException {
        String content = JCameraControl.formatStorage1(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchStorageFormatException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchUnknownException ex) {
            return ex.getExceptionID();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int formatStorage_Jni(int sessionID, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchStorageFormatException {
        String content = JCameraControl.formatStorage2(sessionID, timeoutInSecs);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchStorageFormatException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchUnknownException ex) {
            return ex.getExceptionID();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean setAudioMute_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchStorageFormatException {
        String content = JCameraControl.setAudioMute(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchStorageFormatException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean setAudioUnMute_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchStorageFormatException {
        String content = JCameraControl.setAudioUnMute(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchStorageFormatException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean setEventTrigger_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchStorageFormatException {
        String content = JCameraControl.setEventTrigger(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchStorageFormatException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getVideoRecordStatus_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchStorageFormatException {
        String content = JCameraControl.getVideoRecordStatus(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchStorageFormatException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean zoomIn_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchStorageFormatException, IchInvalidSessionException {
        String content = JCameraControl.zoomIn(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchStorageFormatException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean zoomOut_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchStorageFormatException, IchInvalidSessionException {
        String content = JCameraControl.zoomOut(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchStorageFormatException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean pan_Jni(int sessionID, int xshift, int yshfit) {
        String content = JCameraControl.pan(sessionID, xshift, yshfit);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean panReset_Jni(int sessionID) {
        String content = JCameraControl.panReset(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean toStandbyMode_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchDeviceException {
        String content = JCameraControl.toStandbyMode(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchDeviceException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean setFileProtection_Jni(int sessionID, ICatchFile file, int newprot) throws IchInvalidSessionException, IchSocketException, IchDeviceException {
        String content = JCameraControl.setFileProtection(sessionID, file.toString(), newprot);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchDeviceException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean isSDCardExist_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchDeviceException {
        String content = JCameraControl.isSDCardExist(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchDeviceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getFreeSpaceInImages_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchNoSDCardException, IchDevicePropException {
        String content = JCameraControl.getFreeSpaceInImages(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchNoSDCardException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int getRemainRecordingTime_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchNoSDCardException, IchDevicePropException {
        String content = JCameraControl.getRemainRecordingTime(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchNoSDCardException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean supportedVideoPlayback_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchInvalidSessionException, IchNoSDCardException, IchDevicePropException {
        String content = JCameraControl.supportedVideoPlayback(sessionID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchNoSDCardException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean addEventListener_Jni(int sessionID, int eventID, CoreEventListener listener, int hashCode) throws IchListenerExistsException, IchInvalidSessionException {
        String content = JCameraControl.addEventListener(sessionID, eventID, listener, hashCode);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchListenerExistsException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean removeEventListener_Jni(int sessionID, int eventID, int hashCode) throws IchListenerNotExistsException, IchInvalidSessionException {
        String content = JCameraControl.removeEventListener(sessionID, eventID, hashCode);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchListenerNotExistsException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean addCustomEventListener_Jni(int sessionID, int eventID, CoreEventListener listener, int hashCode) throws IchInvalidSessionException, IchListenerExistsException {
        String content = JCameraControl.addCustomEventListener(sessionID, eventID, listener, hashCode);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchListenerExistsException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean removeCustomEventListener_Jni(int sessionID, int eventID, int hashCode) throws IchInvalidSessionException, IchListenerNotExistsException {
        String content = JCameraControl.removeCustomEventListener(sessionID, eventID, hashCode);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchListenerNotExistsException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static native String startTimeLapse(int var0);

    private static native String stopTimeLapse(int var0);

    private static native String getSupportedModes(int var0);

    private static native String getCurrentCameraMode(int var0);

    private static native String changePreviewMode(int var0, int var1);

    private static native String getCurrentBatteryLevel(int var0);

    private static native String startMovieRecord(int var0);

    private static native String stopMovieRecord(int var0);

    private static native String capturePhotoA(int var0);

    private static native String capturePhotoB(int var0, int var1);

    private static native String triggerCapturePhoto(int var0);

    private static native String formatStorage1(int var0);

    private static native String formatStorage2(int var0, int var1);

    private static native String isSDCardExist(int var0);

    private static native String getFreeSpaceInImages(int var0);

    private static native String getRemainRecordingTime(int var0);

    private static native String supportedVideoPlayback(int var0);

    private static native String setAudioMute(int var0);

    private static native String setAudioUnMute(int var0);

    private static native String setEventTrigger(int var0);

    private static native String getVideoRecordStatus(int var0);

    private static native String zoomIn(int var0);

    private static native String zoomOut(int var0);

    private static native String pan(int var0, int var1, int var2);

    private static native String panReset(int var0);

    private static native String toStandbyMode(int var0);

    private static native String setFileProtection(int var0, String var1, int var2);

    public static native String addEventListener(int var0, int var1, CoreEventListener var2, int var3);

    public static native String removeEventListener(int var0, int var1, int var2);

    private static native String addCustomEventListener(int var0, int var1, CoreEventListener var2, int var3);

    private static native String removeCustomEventListener(int var0, int var1, int var2);

    static {
        NativeLibraryLoader.loadLibrary();
    }
}

