/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.jni;

import com.icatchtek.control.core.jni.extractor.NativeValueExtractor;
import com.icatchtek.control.core.jni.util.NativeLibraryLoader;
import com.icatchtek.control.customer.exception.IchCameraModeException;
import com.icatchtek.control.customer.exception.IchDevicePropException;
import com.icatchtek.control.customer.type.ICatchCamByteArray;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchOutOfMemoryException;
import com.icatchtek.reliant.customer.exception.IchSocketException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;

public class JCameraProperty {
    public static int getCurrentNumericPropertyValue_Jni(int sessionID, int propId) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException, IchTryAgainException {
        String content = JCameraProperty.getCurrentPropertyValueNumeric1(sessionID, propId);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchTryAgainException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int getCurrentNumericPropertyValue_Jni(int sessionID, int propId, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getCurrentPropertyValueNumeric2(sessionID, propId, timeoutInSecs);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean setProperty_Jni(int sessionID, int cmd, byte[] data, int dataSize) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setProperty(sessionID, cmd, data, dataSize);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static int getProperty_Jni(int sessionID, int cmd, byte[] data) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getProperty(sessionID, cmd, data);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static boolean setNumericPropertyValue_Jni(int sessionID, int propId, int value) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setPropertyValueNumeric1(sessionID, propId, value);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean setNumericPropertyValue_Jni(int sessionID, int propId, int value, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setPropertyValueNumeric2(sessionID, propId, value, timeoutInSecs);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getSupportedNumericPropertyValues_Jni(int sessionID, int propId) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedPropertyValuesNumeric1(sessionID, propId);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getSupportedNumericPropertyValues_Jni(int sessionID, int propId, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedPropertyValuesNumeric2(sessionID, propId, timeoutInSecs);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean setStringPropertyValue_Jni(int sessionID, int propId, String value) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setPropertyValueString1(sessionID, propId, value);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean setStringPropertyValue_Jni(int sessionID, int propId, String value, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setPropertyValueString2(sessionID, propId, value, timeoutInSecs);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getCurrentStringPropertyValue_Jni(int sessionID, int propId) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getCurrentPropertyValueString1(sessionID, propId);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getCurrentStringPropertyValue_Jni(int sessionID, int propId, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getCurrentPropertyValueString2(sessionID, propId, timeoutInSecs);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getSupportedStringPropertyValues_Jni(int sessionID, int propId) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedPropertyValuesString1(sessionID, propId);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getSupportedStringPropertyValues_Jni(int sessionID, int propId, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedPropertyValuesString2(sessionID, propId, timeoutInSecs);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean setByteArrayPropertyValue_Jni(int sessionID, int propId, ICatchCamByteArray byteArray, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setPropertyValueByteArray(sessionID, propId, byteArray.getValue(), byteArray.getDataSize(), timeoutInSecs);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getCurrentByteArrayPropertyValue_Jni(int sessionID, int propId, byte[] byteValue, int timeoutInSecs) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException, IchOutOfMemoryException {
        String content = JCameraProperty.getCurrentPropertyValueByteArray(sessionID, propId, byteValue, timeoutInSecs);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean setLightFrequency_Jni(int sessionID, int value) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setLightFrequency(sessionID, value);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getSupportedLightFrequencies_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedLightFrequencies(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getCurrentLightFrequency_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getCurrentLightFrequency(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean setWhiteBalance_Jni(int sessionID, int value) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setWhiteBalance(sessionID, value);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getSupportedWhiteBalances_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedWhiteBalances(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getCurrentWhiteBalance_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getCurrentWhiteBalance(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean setCaptureDelay_Jni(int sessionID, int value) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setCaptureDelay(sessionID, value);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getSupportedCaptureDelays_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedCaptureDelays(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getCurrentCaptureDelay_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getCurrentCaptureDelay(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean setImageSize_Jni(int sessionID, String value) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setImageSize(sessionID, value);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getSupportedImageSizes_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedImageSizes(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getCurrentImageSize_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getCurrentImageSize(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean setVideoSize_Jni(int sessionID, String value) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setVideoSize(sessionID, value);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getSupportedVideoSizes_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedVideoSizes(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getCurrentVideoSize_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getCurrentVideoSize(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean setBurstNumber_Jni(int sessionID, int value) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setBurstNumber(sessionID, value);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getSupportedBurstNumbers_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedBurstNumbers(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getCurrentBurstNumber_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getCurrentBurstNumber(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean setDateStamp_Jni(int sessionID, int timestamp) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.setDateStamp(sessionID, timestamp);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getSupportedDateStamps_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.getSupportedDateStamps(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getCurrentDateStamp_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.getCurrentDateStamp(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static String getSupportedTimeLapseIntervals_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.getSupportedTimeLapseIntervals(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean setTimeLapseInterval_Jni(int sessionID, int stillInterval) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.setTimeLapseInterval(sessionID, stillInterval);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getCurrentTimeLapseInterval_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.getCurrentTimeLapseInterval(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static String getSupportedTimeLapseDurations_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.getSupportedTimeLapseDurations(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean setTimeLapseDuration_Jni(int sessionID, int stillDuration) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.setTimeLapseDuration(sessionID, stillDuration);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getCurrentTimeLapseDuration_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.getCurrentTimeLapseDuration(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int getCurrentUpsideDown_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.getCurrentUpsideDown(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean setUpsideDown_Jni(int sessionID, int usd) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.setUpsideDown(sessionID, usd);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getCurrentSlowMotion_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.getCurrentSlowMotion(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean setSlowMotion_Jni(int sessionID, int sm) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.setSlowMotion(sessionID, sm);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getMaxZoomRatio_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.getMaxZoomRatio(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int getCurrentZoomRatio_Jni(int sessionID) throws IchSocketException, IchCameraModeException, IchDevicePropException, IchInvalidSessionException {
        String content = JCameraProperty.getCurrentZoomRatio(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static String getSupportedCapabilities_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedProperties(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean setSeamless_Jni(int sessionID, int value) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setSeamless(sessionID, value);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getSupportedSeamlesses_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedSeamlesses(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getCurrentSeamless_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getCurrentSeamless(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static String getSupportedStreamingInfos_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getSupportedStreamingInfos(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getCurrentStreamingInfo_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getCurrentStreamingInfo(sessionID);
        try {
            return NativeValueExtractor.extractNativeStringValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean setStreamingInfo_Jni(int sessionID, String videoInfo) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.setStreamingInfo(sessionID, videoInfo);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getPreviewCacheTime_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getPreviewCacheTime(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 400;
        }
    }

    public static int getNumberOfSensors_Jni(int sessionID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.getNumberOfSensors(sessionID);
        try {
            return NativeValueExtractor.extractNativeIntValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean checkCameraCapabilities_Jni(int sessionID, int featureID) throws IchInvalidSessionException, IchSocketException, IchCameraModeException, IchDevicePropException {
        String content = JCameraProperty.checkCameraCapabilities(sessionID, featureID);
        try {
            return NativeValueExtractor.extractNativeBoolValue(content);
        }
        catch (IchSocketException ex) {
            throw ex;
        }
        catch (IchCameraModeException ex) {
            throw ex;
        }
        catch (IchDevicePropException ex) {
            throw ex;
        }
        catch (IchInvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static native String getCurrentPropertyValueNumeric1(int var0, int var1);

    private static native String getCurrentPropertyValueNumeric2(int var0, int var1, int var2);

    private static native String setPropertyValueNumeric1(int var0, int var1, int var2);

    private static native String setPropertyValueNumeric2(int var0, int var1, int var2, int var3);

    private static native String getSupportedPropertyValuesNumeric1(int var0, int var1);

    private static native String getSupportedPropertyValuesNumeric2(int var0, int var1, int var2);

    private static native String setProperty(int var0, int var1, byte[] var2, int var3);

    private static native String getProperty(int var0, int var1, byte[] var2);

    private static native String getCurrentPropertyValueString1(int var0, int var1);

    private static native String getCurrentPropertyValueString2(int var0, int var1, int var2);

    private static native String setPropertyValueString1(int var0, int var1, String var2);

    private static native String setPropertyValueString2(int var0, int var1, String var2, int var3);

    private static native String getSupportedPropertyValuesString1(int var0, int var1);

    private static native String getSupportedPropertyValuesString2(int var0, int var1, int var2);

    private static native String getCurrentPropertyValueByteArray(int var0, int var1, byte[] var2, int var3);

    private static native String setPropertyValueByteArray(int var0, int var1, byte[] var2, int var3, int var4);

    private static native String setLightFrequency(int var0, int var1);

    private static native String getSupportedLightFrequencies(int var0);

    private static native String getCurrentLightFrequency(int var0);

    private static native String setWhiteBalance(int var0, int var1);

    private static native String getSupportedWhiteBalances(int var0);

    private static native String getCurrentWhiteBalance(int var0);

    private static native String setCaptureDelay(int var0, int var1);

    private static native String getSupportedCaptureDelays(int var0);

    private static native String getCurrentCaptureDelay(int var0);

    private static native String setImageSize(int var0, String var1);

    private static native String getSupportedImageSizes(int var0);

    private static native String getCurrentImageSize(int var0);

    private static native String setVideoSize(int var0, String var1);

    private static native String getSupportedVideoSizes(int var0);

    private static native String getCurrentVideoSize(int var0);

    private static native String setBurstNumber(int var0, int var1);

    private static native String getSupportedBurstNumbers(int var0);

    private static native String getCurrentBurstNumber(int var0);

    private static native String setDateStamp(int var0, int var1);

    private static native String getSupportedDateStamps(int var0);

    private static native String getCurrentDateStamp(int var0);

    public static native String getSupportedTimeLapseIntervals(int var0);

    public static native String setTimeLapseInterval(int var0, int var1);

    public static native String getCurrentTimeLapseInterval(int var0);

    public static native String getSupportedTimeLapseDurations(int var0);

    public static native String setTimeLapseDuration(int var0, int var1);

    public static native String getCurrentTimeLapseDuration(int var0);

    public static native String getCurrentUpsideDown(int var0);

    public static native String setUpsideDown(int var0, int var1);

    public static native String getCurrentSlowMotion(int var0);

    public static native String setSlowMotion(int var0, int var1);

    public static native String getMaxZoomRatio(int var0);

    public static native String getCurrentZoomRatio(int var0);

    private static native String getSupportedProperties(int var0);

    private static native String setSeamless(int var0, int var1);

    private static native String getSupportedSeamlesses(int var0);

    private static native String getCurrentSeamless(int var0);

    private static native String getSupportedStreamingInfos(int var0);

    private static native String getCurrentStreamingInfo(int var0);

    private static native String setStreamingInfo(int var0, String var1);

    private static native String getPreviewCacheTime(int var0);

    private static native String getNumberOfSensors(int var0);

    private static native String checkCameraCapabilities(int var0, int var1);

    static {
        NativeLibraryLoader.loadLibrary();
    }
}

