/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.jni.extractor;

import com.icatchtek.control.core.CoreLogger;
import com.icatchtek.control.core.jni.extractor.NativeValueUtil;
import com.icatchtek.control.core.jni.util.ExceptionUtil;
import com.icatchtek.control.customer.exception.IchCameraModeException;
import com.icatchtek.control.customer.exception.IchCaptureImageException;
import com.icatchtek.control.customer.exception.IchDevicePropException;
import com.icatchtek.control.customer.exception.IchInvalidPasswdException;
import com.icatchtek.control.customer.exception.IchNoSDCardException;
import com.icatchtek.control.customer.exception.IchNoSuchPathException;
import com.icatchtek.control.customer.exception.IchStorageFormatException;
import com.icatchtek.reliant.customer.exception.IchAudioStreamClosedException;
import com.icatchtek.reliant.customer.exception.IchBufferTooSmallException;
import com.icatchtek.reliant.customer.exception.IchDeviceBusyException;
import com.icatchtek.reliant.customer.exception.IchDeviceException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchListenerExistsException;
import com.icatchtek.reliant.customer.exception.IchListenerNotExistsException;
import com.icatchtek.reliant.customer.exception.IchNoSuchFileException;
import com.icatchtek.reliant.customer.exception.IchNotImplementedException;
import com.icatchtek.reliant.customer.exception.IchNotSupportedException;
import com.icatchtek.reliant.customer.exception.IchOutOfMemoryException;
import com.icatchtek.reliant.customer.exception.IchPauseFailedException;
import com.icatchtek.reliant.customer.exception.IchPbStreamPausedException;
import com.icatchtek.reliant.customer.exception.IchPermissionDeniedException;
import com.icatchtek.reliant.customer.exception.IchResumeFailedException;
import com.icatchtek.reliant.customer.exception.IchSeekFailedException;
import com.icatchtek.reliant.customer.exception.IchSocketException;
import com.icatchtek.reliant.customer.exception.IchStreamNotRunningException;
import com.icatchtek.reliant.customer.exception.IchStreamNotSupportException;
import com.icatchtek.reliant.customer.exception.IchStreamPublishException;
import com.icatchtek.reliant.customer.exception.IchTimeOutException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.exception.IchUnknownException;
import com.icatchtek.reliant.customer.exception.IchVideoStreamClosedException;

public class NativeValueExtractor {
    public static String extractNativeStringValue(String content) throws IchInvalidSessionException, IchListenerNotExistsException, IchDeviceBusyException, IchDeviceException, IchNotSupportedException, IchNotImplementedException, IchTryAgainException, IchBufferTooSmallException, IchOutOfMemoryException, IchNoSuchFileException, IchNoSuchPathException, IchInvalidArgumentException, IchTimeOutException, IchSocketException, IchPermissionDeniedException, IchStreamNotRunningException, IchCameraModeException, IchUnknownException, IchDevicePropException, IchCaptureImageException, IchStorageFormatException, IchListenerExistsException, IchNoSDCardException, IchSeekFailedException, IchPauseFailedException, IchResumeFailedException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchInvalidPasswdException, IchTransportException, IchPbStreamPausedException, IchStreamNotSupportException, IchStreamPublishException {
        if (content.contains("RET_ERR")) {
            int errorID = NativeValueUtil.getErrValue(content);
            NativeValueExtractor.errorToException(errorID);
        }
        if (content.contains("RET_STRING")) {
            return NativeValueUtil.getStringValue(content);
        }
        CoreLogger.logE("NativeValueExtractor", "Fatal error, invalid data from jni layer." + content);
        return null;
    }

    public static int extractNativeIntValue(String content) throws IchInvalidSessionException, IchListenerNotExistsException, IchDeviceBusyException, IchDeviceException, IchNotSupportedException, IchNotImplementedException, IchTryAgainException, IchBufferTooSmallException, IchOutOfMemoryException, IchNoSuchFileException, IchNoSuchPathException, IchInvalidArgumentException, IchTimeOutException, IchSocketException, IchPermissionDeniedException, IchStreamNotRunningException, IchCameraModeException, IchUnknownException, IchDevicePropException, IchCaptureImageException, IchStorageFormatException, IchListenerExistsException, IchNoSDCardException, IchSeekFailedException, IchPauseFailedException, IchResumeFailedException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchInvalidPasswdException, IchTransportException, IchPbStreamPausedException, IchStreamNotSupportException, IchStreamPublishException {
        if (content.contains("RET_ERR")) {
            int errorID = NativeValueUtil.getErrValue(content);
            NativeValueExtractor.errorToException(errorID);
        }
        if (content.contains("RET_INT")) {
            return NativeValueUtil.getIntValue(content);
        }
        CoreLogger.logE("NativeValueExtractor", "Fatal error, invalid data from jni layer." + content);
        return -1;
    }

    public static long extractNativeLongValue(String content) throws IchInvalidSessionException, IchListenerNotExistsException, IchDeviceBusyException, IchDeviceException, IchNotSupportedException, IchNotImplementedException, IchTryAgainException, IchBufferTooSmallException, IchOutOfMemoryException, IchNoSuchFileException, IchNoSuchPathException, IchInvalidArgumentException, IchTimeOutException, IchSocketException, IchPermissionDeniedException, IchStreamNotRunningException, IchCameraModeException, IchUnknownException, IchDevicePropException, IchCaptureImageException, IchStorageFormatException, IchListenerExistsException, IchNoSDCardException, IchSeekFailedException, IchPauseFailedException, IchResumeFailedException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchInvalidPasswdException, IchTransportException, IchPbStreamPausedException, IchStreamNotSupportException, IchStreamPublishException {
        if (content.contains("RET_ERR")) {
            int errorID = NativeValueUtil.getErrValue(content);
            NativeValueExtractor.errorToException(errorID);
        }
        if (content.contains("RET_LONG")) {
            return NativeValueUtil.getLongValue(content);
        }
        CoreLogger.logE("NativeValueExtractor", "Fatal error, invalid data from jni layer." + content);
        return -1L;
    }

    public static boolean extractNativeBoolValue(String content) throws IchInvalidSessionException, IchListenerNotExistsException, IchDeviceBusyException, IchDeviceException, IchNotSupportedException, IchNotImplementedException, IchTryAgainException, IchBufferTooSmallException, IchOutOfMemoryException, IchNoSuchFileException, IchNoSuchPathException, IchInvalidArgumentException, IchTimeOutException, IchSocketException, IchPermissionDeniedException, IchStreamNotRunningException, IchCameraModeException, IchUnknownException, IchDevicePropException, IchPauseFailedException, IchResumeFailedException, IchCaptureImageException, IchStorageFormatException, IchListenerExistsException, IchNoSDCardException, IchSeekFailedException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchInvalidPasswdException, IchTransportException, IchPbStreamPausedException, IchStreamNotSupportException, IchStreamPublishException {
        if (content.contains("RET_ERR")) {
            int errorID = NativeValueUtil.getErrValue(content);
            NativeValueExtractor.errorToException(errorID);
        }
        if (content.contains("RET_BOOL")) {
            return NativeValueUtil.getBoolValue(content);
        }
        CoreLogger.logE("NativeValueExtractor", "Fatal error, invalid data from jni layer." + content);
        return false;
    }

    public static double extractNativeDoubleValue(String content) throws IchInvalidSessionException, IchListenerNotExistsException, IchDeviceBusyException, IchDeviceException, IchNotSupportedException, IchNotImplementedException, IchTryAgainException, IchBufferTooSmallException, IchOutOfMemoryException, IchNoSuchFileException, IchNoSuchPathException, IchInvalidArgumentException, IchTimeOutException, IchSocketException, IchPermissionDeniedException, IchStreamNotRunningException, IchCameraModeException, IchUnknownException, IchDevicePropException, IchPauseFailedException, IchResumeFailedException, IchCaptureImageException, IchStorageFormatException, IchListenerExistsException, IchNoSDCardException, IchSeekFailedException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchInvalidPasswdException, IchTransportException, IchPbStreamPausedException, IchStreamNotSupportException, IchStreamPublishException {
        if (content.contains("RET_ERR")) {
            int errorID = NativeValueUtil.getErrValue(content);
            NativeValueExtractor.errorToException(errorID);
        }
        if (content.contains("RET_DOUBLE")) {
            return NativeValueUtil.getDoubleValue(content);
        }
        CoreLogger.logE("NativeValueExtractor", "Fatal error, invalid data from jni layer. " + content);
        return -1.0;
    }

    private static void errorToException(int errorID) throws IchDeviceBusyException, IchDeviceException, IchNotSupportedException, IchNotImplementedException, IchTryAgainException, IchBufferTooSmallException, IchOutOfMemoryException, IchNoSuchFileException, IchNoSuchPathException, IchInvalidSessionException, IchInvalidArgumentException, IchTimeOutException, IchSocketException, IchPermissionDeniedException, IchStreamNotRunningException, IchCameraModeException, IchUnknownException, IchDevicePropException, IchCaptureImageException, IchStorageFormatException, IchListenerExistsException, IchListenerNotExistsException, IchNoSDCardException, IchSeekFailedException, IchPauseFailedException, IchResumeFailedException, IchVideoStreamClosedException, IchAudioStreamClosedException, IchInvalidPasswdException, IchTransportException, IchPbStreamPausedException, IchStreamNotSupportException, IchStreamPublishException {
        switch (errorID) {
            case -1: {
                throw new IchDeviceBusyException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -2: {
                throw new IchDeviceException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -3: {
                throw new IchNotSupportedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -4: {
                throw new IchNotImplementedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -6: {
                throw new IchTryAgainException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -7: {
                throw new IchBufferTooSmallException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -8: {
                throw new IchOutOfMemoryException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -9: {
                throw new IchNoSuchFileException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -10: {
                throw new IchNoSuchPathException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -11: {
                throw new IchInvalidSessionException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -327: 
            case -326: 
            case -12: {
                throw new IchInvalidArgumentException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -26: {
                throw new IchTimeOutException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -14: 
            case -13: {
                throw new IchSocketException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -5: {
                throw new IchPermissionDeniedException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -305: 
            case -304: 
            case -303: 
            case -302: 
            case -301: {
                throw new IchCameraModeException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -330: 
            case -329: 
            case -323: 
            case -322: 
            case -321: 
            case -320: 
            case -319: 
            case -318: 
            case -317: 
            case -316: 
            case -315: 
            case -314: 
            case -313: 
            case -312: 
            case -311: 
            case -310: 
            case -309: 
            case -308: 
            case -307: 
            case -306: 
            case -300: {
                throw new IchDevicePropException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -324: {
                throw new IchCaptureImageException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -325: {
                throw new IchStorageFormatException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -328: {
                throw new IchNoSDCardException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -60: {
                throw new IchListenerExistsException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -61: {
                throw new IchListenerNotExistsException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -336: {
                throw new IchInvalidPasswdException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -337: {
                throw new IchTransportException(ExceptionUtil.getErrorMessage(errorID));
            }
            case -104: 
            case -103: {
                throw new IchStreamPublishException(ExceptionUtil.getErrorMessage(errorID));
            }
        }
        CoreLogger.logE("error Exception mapping", "unknown errorID: " + errorID);
        IchUnknownException ex = new IchUnknownException(ExceptionUtil.getErrorMessage(errorID));
        ex.setExceptionID(errorID);
        throw ex;
    }
}

