/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.jni.extractor;

public class NativeValueUtil {
    public static int getIntValue(String content) {
        String[] values = content.split("::");
        if (values.length != 2 || !values[0].equals("RET_INT")) {
            return -1;
        }
        return Integer.parseInt(values[1]);
    }

    public static long getLongValue(String content) {
        String[] values = content.split("::");
        if (values.length != 2 || !values[0].equals("RET_LONG")) {
            return -1L;
        }
        return Long.parseLong(values[1]);
    }

    public static int getErrValue(String content) {
        String[] values = content.split("::");
        if (values.length != 2 || !values[0].equals("RET_ERR")) {
            return -11111;
        }
        return Integer.parseInt(values[1]);
    }

    public static boolean getBoolValue(String content) {
        String[] values = content.split("::");
        if (values.length != 2 || !values[0].equals("RET_BOOL")) {
            return false;
        }
        return values[1].equals("true");
    }

    public static double getDoubleValue(String content) {
        String[] values = content.split("::");
        if (values.length != 2 || !values[0].equals("RET_DOUBLE")) {
            return -1.0;
        }
        return Double.parseDouble(values[1]);
    }

    public static String getStringValue(String content) {
        String[] values = content.split("::");
        if (values.length != 2 || !values[0].equals("RET_STRING")) {
            return null;
        }
        return values[1];
    }
}

