/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.jni.util;

import com.icatchtek.control.core.CoreLogger;
import com.icatchtek.control.core.jni.util.PartialFrameInfo;
import com.icatchtek.control.customer.type.ICatchCamPhotoExif;
import com.icatchtek.reliant.customer.type.ICatchAudioFormat;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class DataTypeUtil {
    public static ICatchCamPhotoExif toPhotoExif(String exifStr) {
        return null;
    }

    public static List<Integer> splitStringToIntList(String value) {
        if (value == null) {
            return new LinkedList<Integer>();
        }
        String[] intValStrs = value.split(";");
        LinkedList<Integer> intVals = new LinkedList<Integer>();
        for (String intValStr : intValStrs) {
            intVals.add(Integer.parseInt(intValStr));
        }
        return intVals;
    }

    public static List<ICatchVideoFormat> splitStringToVideoFormatList(String value) {
        String[] videoFormatValStrs;
        if (value == null) {
            return new LinkedList<ICatchVideoFormat>();
        }
        LinkedList<ICatchVideoFormat> videoFormats = new LinkedList<ICatchVideoFormat>();
        for (String videoFormatValStr : videoFormatValStrs = value.split(";")) {
            ICatchVideoFormat videoFormat = DataTypeUtil.toVideoFormat(videoFormatValStr);
            if (videoFormat == null) continue;
            videoFormats.add(videoFormat);
        }
        return videoFormats;
    }

    public static List<String> splitStringToStringList(String value) {
        if (value == null) {
            return new LinkedList<String>();
        }
        String[] strValStrs = value.split(";");
        LinkedList<String> stringVals = new LinkedList<String>();
        for (String stringVal : strValStrs) {
            stringVals.add(stringVal);
        }
        return stringVals;
    }

    public static PartialFrameInfo toPartialFrameInfo(String value) {
        if (value == null) {
            return null;
        }
        int codec = 0;
        int frameSize = 0;
        double presentationTime = 0.0;
        try {
            JSONObject json = new JSONObject(value);
            codec = json.getInt("codec");
            frameSize = json.getInt("frameSize");
            presentationTime = json.getDouble("presentationTime");
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
        PartialFrameInfo frameInfo = new PartialFrameInfo();
        frameInfo.setCodec(codec);
        frameInfo.setFrameSize(frameSize);
        frameInfo.setPresentationTime(presentationTime);
        return frameInfo;
    }

    public static ICatchVideoFormat toVideoFormat(String value) {
        if (value == null) {
            return null;
        }
        String mineType = "";
        int codec = 255;
        int videoW = 0;
        int videoH = 0;
        int bitrate = 0;
        int durationUs = 0;
        int maxInputSize = 0;
        int fps = 0;
        CoreLogger.logI("DtaTypeUtil", "value: " + value);
        try {
            JSONObject json = new JSONObject(value);
            mineType = json.getString("codecName");
            codec = json.getInt("codec");
            videoW = json.getInt("videoW");
            videoH = json.getInt("videoH");
            bitrate = json.getInt("bitrate");
            durationUs = json.getInt("durationUs");
            maxInputSize = json.getInt("maxInputSize");
            fps = json.getInt("frameRate");
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
        CoreLogger.logI("DtaTypeUtil", "mineType: " + mineType);
        CoreLogger.logI("DtaTypeUtil", "codec: " + codec);
        CoreLogger.logI("DtaTypeUtil", "videoW: " + videoW);
        CoreLogger.logI("DtaTypeUtil", "videoH: " + videoH);
        CoreLogger.logI("DtaTypeUtil", "bitrate: " + bitrate);
        CoreLogger.logI("DtaTypeUtil", "durationUs: " + durationUs);
        CoreLogger.logI("DtaTypeUtil", "maxInputSize: " + maxInputSize);
        CoreLogger.logI("DtaTypeUtil", "fps: " + fps);
        ICatchVideoFormat videoFormat = new ICatchVideoFormat();
        videoFormat.setMineType(mineType);
        videoFormat.setCodec(codec);
        videoFormat.setVideoW(videoW);
        videoFormat.setVideoH(videoH);
        videoFormat.setBitrate(bitrate);
        videoFormat.setDurationUs(durationUs);
        videoFormat.setMaxInputSize(maxInputSize);
        videoFormat.setFrameRate(fps);
        return videoFormat;
    }

    public static String toVideoFormat(ICatchVideoFormat videoFormat) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("mineType", (Object)(videoFormat.getMineType() != null ? videoFormat.getMineType() : "none/none"));
            jsonObject.put("codec", videoFormat.getCodec());
            jsonObject.put("videoW", videoFormat.getVideoW());
            jsonObject.put("videoH", videoFormat.getVideoH());
            jsonObject.put("bitrate", videoFormat.getBitrate());
            jsonObject.put("durationUs", videoFormat.getDurationUs());
            jsonObject.put("maxInputSize", videoFormat.getMaxInputSize());
            jsonObject.put("frameRate", videoFormat.getFrameRate());
            return jsonObject.toString();
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ICatchAudioFormat toAudioFormat(String value) {
        if (value == null) {
            return null;
        }
        int codec = 255;
        int frequency = 44100;
        int nChannels = 2;
        int sampleBits = 16;
        CoreLogger.logI("DtaTypeUtil", "value: " + value);
        try {
            JSONObject json = new JSONObject(value);
            codec = json.getInt("codec");
            frequency = json.getInt("frequency");
            nChannels = json.getInt("nChannels");
            sampleBits = json.getInt("sampleBits");
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
        CoreLogger.logI("DtaTypeUtil", "codec: " + codec);
        CoreLogger.logI("DtaTypeUtil", "frequency: " + frequency);
        CoreLogger.logI("DtaTypeUtil", "nChannels: " + nChannels);
        CoreLogger.logI("DtaTypeUtil", "sampleBits: " + sampleBits);
        ICatchAudioFormat audioFormat = new ICatchAudioFormat();
        audioFormat.setCodec(codec);
        audioFormat.setFrequency(frequency);
        audioFormat.setNChannels(nChannels);
        audioFormat.setSampleBits(sampleBits);
        return audioFormat;
    }
}

