/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.core.util.type;

import com.icatchtek.control.core.CoreLogger;
import com.icatchtek.reliant.customer.type.ICatchFile;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class NativeFile {
    public static List<ICatchFile> toIcatchFiles(String ntvfilesStr) {
        String[] fileObjStrs;
        LinkedList<ICatchFile> files = new LinkedList<ICatchFile>();
        if (ntvfilesStr == null) {
            return files;
        }
        for (String fileObjStr : fileObjStrs = ntvfilesStr.split(";")) {
            ICatchFile file = NativeFile.toICatchFile(fileObjStr);
            files.add(file);
        }
        return files;
    }

    public static ICatchFile toICatchFile(String substring) {
        int fileHandle = -1;
        String filePath = "";
        String fileName = "";
        String fileDate = "";
        long fileSize = -1L;
        double frameRate = 0.0;
        int fileWidth = 0;
        int fileHeight = 0;
        int fileType = 16;
        int fileProtection = 0;
        int fileDuration = 0;
        try {
            JSONObject json = new JSONObject(substring);
            fileHandle = json.getInt("fileHandle");
            filePath = json.getString("filePath");
            fileName = json.getString("fileName");
            fileDate = json.getString("fileDate");
            fileSize = json.getLong("fileSize");
            frameRate = json.getInt("frameRate");
            fileWidth = json.getInt("fileWidth");
            fileHeight = json.getInt("fileHeight");
            fileType = json.getInt("fileType");
            fileProtection = json.getInt("fileProtection");
            fileDuration = json.getInt("fileDuration");
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
        CoreLogger.logI("String2IcatchFile", "fileHandle: " + fileHandle);
        if (fileHandle < 0) {
            return null;
        }
        return new ICatchFile(fileHandle, fileType, filePath, fileName, fileSize, fileDate, frameRate, fileWidth, fileHeight, fileProtection, fileDuration);
    }

    public static String toICatchFile(ICatchFile file) {
        JSONObject attributes = new JSONObject();
        CoreLogger.logI("File2String", "fileHandle: " + file.getFileHandle());
        try {
            attributes.put("fileHandle", file.getFileHandle());
            attributes.put("filePath", (Object)file.getFilePath());
            attributes.put("fileName", (Object)file.getFileName());
            attributes.put("fileDate", (Object)file.getFileName());
            attributes.put("fileType", file.getFileType());
            attributes.put("fileSize", file.getFileSize());
            attributes.put("fileWidth", file.getFileWidth());
            attributes.put("fileHeight", file.getFileHeight());
            attributes.put("frameRate", file.getFrameRate());
            attributes.put("fileProtection", file.getFileProtection());
            attributes.put("fileDuration", file.getFileDuration());
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
        return attributes.toString();
    }
}

