/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.customer;

import com.icatchtek.control.core.feature.ICatchCameraControlImpl;
import com.icatchtek.control.core.feature.ICatchCameraInfoImpl;
import com.icatchtek.control.core.feature.ICatchCameraPlaybackImpl;
import com.icatchtek.control.core.feature.ICatchCameraPropertyImpl;
import com.icatchtek.control.core.feature.ICatchCameraStateImpl;
import com.icatchtek.control.core.feature.ICatchSingletonFactory;
import com.icatchtek.control.core.jni.JCameraSession;
import com.icatchtek.control.customer.ICatchCameraAssist;
import com.icatchtek.control.customer.ICatchCameraConfig;
import com.icatchtek.control.customer.ICatchCameraControl;
import com.icatchtek.control.customer.ICatchCameraInfo;
import com.icatchtek.control.customer.ICatchCameraPlayback;
import com.icatchtek.control.customer.ICatchCameraProperty;
import com.icatchtek.control.customer.ICatchCameraState;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.transport.ICatchINETTransport;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCBulkTransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCIsoTransport;
import com.icatchtek.reliant.customer.transport.ICatchUsbScsiTransport;

public class ICatchCameraSession {
    private int sessionID = JCameraSession.createJniSession_Jni();
    private ICatchCameraInfo infoClient;
    private ICatchCameraState stateClient;
    private ICatchCameraControl controlClient;
    private ICatchCameraProperty propertyClient;
    private ICatchCameraPlayback playbackClient;

    public static ICatchCameraSession createSession() {
        return new ICatchCameraSession();
    }

    public static ICatchCameraConfig getCameraConfig(ICatchITransport transport) throws IchInvalidArgumentException {
        return ICatchSingletonFactory.getInstance().getCameraConfig(transport);
    }

    public static ICatchCameraAssist getCameraAssist(ICatchITransport transport) throws IchInvalidArgumentException {
        return ICatchSingletonFactory.getInstance().getCameraAssist(transport);
    }

    @Deprecated
    public int getSessionID() {
        return this.sessionID;
    }

    public boolean prepareSession(ICatchITransport transport) throws IchTransportException {
        if (transport instanceof ICatchINETTransport) {
            String ipAddr = ((ICatchINETTransport)transport).getIpAddress();
            int retVal = JCameraSession.prepareSession_Jni(this.sessionID, ipAddr, "", "");
            if (retVal < 0) {
                return false;
            }
        } else if (transport instanceof ICatchUVCBulkTransport) {
            int retVal = JCameraSession.prepareSession_Jni(this.sessionID, true, -1, -1, -1);
            if (retVal < 0) {
                return false;
            }
        } else if (transport instanceof ICatchUVCIsoTransport) {
            ICatchUVCIsoTransport isoTransport = (ICatchUVCIsoTransport)transport;
            int retVal = JCameraSession.prepareSession_Jni(this.sessionID, false, isoTransport.getVendorID(), isoTransport.getProductID(), isoTransport.getFileDescriptor());
            if (retVal < 0) {
                return false;
            }
        } else if (transport instanceof ICatchUsbScsiTransport) {
            int retVal = JCameraSession.prepareSession_Jni(this.sessionID, true, -1, -1, -1);
            if (retVal < 0) {
                return false;
            }
        } else {
            throw new IchTransportException("Transport not supported [" + transport + "]");
        }
        this.infoClient = new ICatchCameraInfoImpl(this.sessionID);
        this.stateClient = new ICatchCameraStateImpl(this.sessionID);
        this.controlClient = new ICatchCameraControlImpl(this.sessionID, transport);
        this.propertyClient = new ICatchCameraPropertyImpl(this.sessionID);
        this.playbackClient = new ICatchCameraPlaybackImpl(this.sessionID);
        return true;
    }

    public boolean destroySession() throws IchInvalidSessionException {
        if (this.sessionID < 0) {
            return true;
        }
        boolean retVal = JCameraSession.destroySession_Jni(this.sessionID);
        return retVal;
    }

    public boolean checkConnection() throws IchInvalidSessionException {
        this.checkSession();
        return JCameraSession.checkConnection_Jni(this.sessionID);
    }

    public ICatchCameraInfo getInfoClient() throws IchInvalidSessionException {
        this.checkSession();
        return this.infoClient;
    }

    public ICatchCameraState getStateClient() throws IchInvalidSessionException {
        this.checkSession();
        return this.stateClient;
    }

    public ICatchCameraControl getControlClient() throws IchInvalidSessionException {
        this.checkSession();
        return this.controlClient;
    }

    public ICatchCameraProperty getPropertyClient() throws IchInvalidSessionException {
        this.checkSession();
        return this.propertyClient;
    }

    public ICatchCameraPlayback getPlaybackClient() throws IchInvalidSessionException {
        this.checkSession();
        return this.playbackClient;
    }

    private void checkSession() throws IchInvalidSessionException {
        if (this.sessionID < 0) {
            IchInvalidSessionException ex = new IchInvalidSessionException();
            throw ex;
        }
    }
}

