/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.control.customer.type;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class ICatchCamPhotoExif {
    public static final String TAG_ORIENTATION = "Orientation";
    public static final String TAG_DATETIME = "DateTime";
    public static final String TAG_MAKE = "Make";
    public static final String TAG_MODEL = "Model";
    public static final String TAG_FLASH = "Flash";
    public static final String TAG_IMAGE_WIDTH = "ImageWidth";
    public static final String TAG_IMAGE_LENGTH = "ImageLength";
    public static final String TAG_GPS_LATITUDE = "GPSLatitude";
    public static final String TAG_GPS_LONGITUDE = "GPSLongitude";
    public static final String TAG_GPS_LATITUDE_REF = "GPSLatitudeRef";
    public static final String TAG_GPS_LONGITUDE_REF = "GPSLongitudeRef";
    public static final String TAG_EXPOSURE_TIME = "ExposureTime";
    public static final String TAG_APERTURE = "FNumber";
    public static final String TAG_ISO = "ISOSpeedRatings";
    public static final String TAG_GPS_ALTITUDE = "GPSAltitude";
    public static final String TAG_GPS_ALTITUDE_REF = "GPSAltitudeRef";
    public static final String TAG_GPS_TIMESTAMP = "GPSTimeStamp";
    public static final String TAG_GPS_DATESTAMP = "GPSDateStamp";
    public static final String TAG_WHITE_BALANCE = "WhiteBalance";
    public static final String TAG_FOCAL_LENGTH = "FocalLength";
    public static final String TAG_GPS_PROCESSING_METHOD = "GPSProcessingMethod";
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final int ORIENTATION_NORMAL = 1;
    public static final int ORIENTATION_FLIP_HORIZONTAL = 2;
    public static final int ORIENTATION_ROTATE_180 = 3;
    public static final int ORIENTATION_FLIP_VERTICAL = 4;
    public static final int ORIENTATION_TRANSPOSE = 5;
    public static final int ORIENTATION_ROTATE_90 = 6;
    public static final int ORIENTATION_TRANSVERSE = 7;
    public static final int ORIENTATION_ROTATE_270 = 8;
    public static final int WHITEBALANCE_AUTO = 0;
    public static final int WHITEBALANCE_MANUAL = 1;
    private static SimpleDateFormat sFormatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss", Locale.US);
    private HashMap<String, String> mAttributes;
    private boolean mHasThumbnail;

    public ICatchCamPhotoExif(String exifs) {
        this.loadAttributes(exifs);
    }

    public String getAttribute(String tag) {
        return this.mAttributes.get(tag);
    }

    public int getAttributeInt(String tag, int defaultValue) {
        String value = this.mAttributes.get(tag);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public double getAttributeDouble(String tag, double defaultValue) {
        String value = this.mAttributes.get(tag);
        if (value == null) {
            return defaultValue;
        }
        try {
            int index = value.indexOf("/");
            if (index == -1) {
                return defaultValue;
            }
            double denom = Double.parseDouble(value.substring(index + 1));
            if (denom == 0.0) {
                return defaultValue;
            }
            double num = Double.parseDouble(value.substring(0, index));
            return num / denom;
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public void setAttribute(String tag, String value) {
        this.mAttributes.put(tag, value);
    }

    private void loadAttributes(String exifs) {
        String[] attributes;
        this.mAttributes = new HashMap();
        for (String attribute : attributes = exifs.split(";")) {
            String[] temps = attribute.split(":");
            if (temps == null || temps.length <= 1) continue;
            String attrName = temps[0];
            String attrValue = temps[1];
            if (attrName.equals("hasThumbnail")) {
                this.mHasThumbnail = attrValue.equalsIgnoreCase("true");
                continue;
            }
            this.mAttributes.put(attrName, attrValue);
        }
    }

    public boolean hasThumbnail() {
        return this.mHasThumbnail;
    }

    public boolean getLatLong(float[] output) {
        String latValue = this.mAttributes.get(TAG_GPS_LATITUDE);
        String latRef = this.mAttributes.get(TAG_GPS_LATITUDE_REF);
        String lngValue = this.mAttributes.get(TAG_GPS_LONGITUDE);
        String lngRef = this.mAttributes.get(TAG_GPS_LONGITUDE_REF);
        if (latValue != null && latRef != null && lngValue != null && lngRef != null) {
            try {
                output[0] = ICatchCamPhotoExif.convertRationalLatLonToFloat(latValue, latRef);
                output[1] = ICatchCamPhotoExif.convertRationalLatLonToFloat(lngValue, lngRef);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public double getAltitude(double defaultValue) {
        double altitude = this.getAttributeDouble(TAG_GPS_ALTITUDE, -1.0);
        int ref = this.getAttributeInt(TAG_GPS_ALTITUDE_REF, -1);
        if (altitude >= 0.0 && ref >= 0) {
            return altitude * (double)(ref == 1 ? -1 : 1);
        }
        return defaultValue;
    }

    public long getDateTime() {
        String dateTimeString = this.mAttributes.get(TAG_DATETIME);
        if (dateTimeString == null) {
            return -1L;
        }
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime = sFormatter.parse(dateTimeString, pos);
            if (datetime == null) {
                return -1L;
            }
            return datetime.getTime();
        }
        catch (IllegalArgumentException ex) {
            return -1L;
        }
    }

    public long getGpsDateTime() {
        String date = this.mAttributes.get(TAG_GPS_DATESTAMP);
        String time = this.mAttributes.get(TAG_GPS_TIMESTAMP);
        if (date == null || time == null) {
            return -1L;
        }
        String dateTimeString = date + ' ' + time;
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime = sFormatter.parse(dateTimeString, pos);
            if (datetime == null) {
                return -1L;
            }
            return datetime.getTime();
        }
        catch (IllegalArgumentException ex) {
            return -1L;
        }
    }

    private static float convertRationalLatLonToFloat(String rationalString, String ref) {
        try {
            String[] parts = rationalString.split(",");
            String[] pair = parts[0].split("/");
            double degrees = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[1].split("/");
            double minutes = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[2].split("/");
            double seconds = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            double result = degrees + minutes / 60.0 + seconds / 3600.0;
            if (ref.equals("S") || ref.equals("W")) {
                return (float)(-result);
            }
            return (float)result;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    static {
        sFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

