/*
 * Decompiled with CFR 0.152.
 */
package cn.ivan95.me;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;

@SpringBootApplication
public class Application
extends SpringBootServletInitializer {
    protected static final Logger logger = LoggerFactory.getLogger(Application.class);
    public static String name;
    public static String port;

    @Value(value="${spring.application.name}")
    public void setName(String name) {
        Application.name = name;
    }

    @Value(value="${server.port}")
    public void setPort(String port) {
        Application.port = port;
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        logger.info("spring boot  war\u542f\u52a8");
        SpringApplicationBuilder springApplicationBuilder = application.sources(new Class[]{Application.class});
        try {
            logger.info("\n----------------------------------------------------------\n\tApplication '{}' is running! Access URLs:\n\tLocal: \t\thttp://localhost:{}\n\tExternal: \thttp://{}:{}\n\tDB: \thttp://localhost:{}/console\n\tDoc: \thttp://{}:{}/doc.html\n----------------------------------------------------------", new Object[]{name, port, InetAddress.getLocalHost().getHostAddress(), port, port, InetAddress.getLocalHost().getHostAddress(), port});
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return springApplicationBuilder;
    }

    public static void main(String[] args) throws UnknownHostException {
        logger.info("spring boot  jar\u542f\u52a8");
        SpringApplication.run(Application.class, (String[])args);
        logger.info("\n----------------------------------------------------------\n\tApplication '{}' is running! Access URLs:\n\tLocal: \t\thttp://localhost:{}\n\tExternal: \thttp://{}:{}\n\tDB: \thttp://localhost:{}/console\n\tDoc: \thttp://{}:{}/doc.html\n----------------------------------------------------------", new Object[]{name, port, InetAddress.getLocalHost().getHostAddress(), port, port, InetAddress.getLocalHost().getHostAddress(), port});
        long usedMemory = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        System.out.println("\u4f7f\u7528\u5185\u5b58\u4e3a\uff1a" + (double)usedMemory / 1024.0 + "mb");
    }
}

