/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.doc.core.swagger.config;

import cn.jdevelops.doc.core.swagger.bean.SwaggerBean;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class ConsoleConfig
implements ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsoleConfig.class);
    public static final String SPIRIT = "/";
    @Value(value="${server.port:8080}")
    private int serverPort;
    @Value(value="${server.servlet.context-path:/}")
    private String serverName;
    @Autowired(required=false)
    private SwaggerBean swaggerBean;

    public void run(ApplicationArguments args) throws Exception {
        try {
            if (SPIRIT.equals(this.serverName)) {
                this.serverName = "";
            }
            String groupStr = "";
            String groupName = this.swaggerBean.getGroupName();
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                groupStr = "?group=" + this.swaggerBean.getGroupName();
            }
            log.info("\n----------------------------------------------------------\n\t swagger \u542f\u52a8. Access URLs:\n\tswagger \u542f\u52a8\u6210\u529f\uff01\u63a5\u53e3\u6587\u6863\u5730\u5740(cloud\u6ca1\u6709\u9875\u9762)-HTML: http://" + ConsoleConfig.getRealIp() + ":" + this.serverPort + this.serverName + "/doc.html\n\tswagger \u542f\u52a8\u6210\u529f\uff01\u63a5\u53e3\u6587\u6863\u5730\u5740-JSON: http://" + ConsoleConfig.getRealIp() + ":" + this.serverPort + this.serverName + "/v2/api-docs" + groupStr + "\n\tswagger \u542f\u52a8\u6210\u529f\uff01\u63a5\u53e3\u6587\u6863\u5730\u5740-OpenApi-JSON: http://" + ConsoleConfig.getRealIp() + ":" + this.serverPort + this.serverName + "/v3/api-docs" + groupStr + "\n\t----------------------------------------------------------");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getRealIp() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp() || !netInterface.getDisplayName().contains("Intel") && !netInterface.getDisplayName().contains("Realtek")) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
                break block2;
            }
        }
        catch (SocketException e) {
            log.error("\u83b7\u53d6\u4e3b\u673aip\u5730\u5740\u65f6\u51fa\u9519" + e.getMessage());
        }
        return "127.0.0.1";
    }
}

