/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.cutout;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Log;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowManager;
import com.huawei.appmarket.component.buoycircle.impl.cutout.CutoutInfo;
import com.huawei.appmarket.component.buoycircle.impl.delegete.BuoyBridgeActivity;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.manager.FloatWindowManager;
import com.huawei.appmarket.component.buoycircle.impl.storage.BuoyStorage;
import com.huawei.appmarket.component.buoycircle.impl.utils.WindowUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuoyCutoutHelper {
    private static final String TAG = "BuoyCutoutHelper";
    private static final int NO_CUTOUT = 0;
    private static BuoyCutoutHelper instance;
    private Map<Integer, CutoutInfo> cutoutInfoMap = new HashMap<Integer, CutoutInfo>();
    private static final int DEFAULT = 0;
    private static final int NOTCH_INDEX = 0;
    private static final String DISPLAY_NOTCH_STATUS = "display_notch_status";
    private static final int WIDTH_INDEX = 0;
    private static final int HEIGHT_INDEX = 1;
    private static final int NOTCHOPEN = 0;
    private static final int NOTCHCLOSE = 1;
    private static final int APP_FOLLOW_SYSTEM = 0;
    private static final int APP_SHOW_NOTCH = 1;
    private static final int APP_HIDE_NOTCH = 2;

    public static synchronized BuoyCutoutHelper getInstance() {
        if (instance == null) {
            instance = new BuoyCutoutHelper();
        }
        return instance;
    }

    private void doFinish(Activity activity) {
        if (activity instanceof BuoyBridgeActivity) {
            activity.finish();
        }
        FloatWindowManager.getInstance().showSmallWindow();
    }

    public void getCutoutSize(final Activity activity) {
        if (activity == null || activity.isFinishing()) {
            this.doFinish(activity);
            return;
        }
        if (Build.VERSION.SDK_INT <= 26 || !this.hasSetOpenNotch((Context)activity)) {
            this.doFinish(activity);
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BuoyCutoutHelper.this.startGetCutoutSize(activity);
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    private void startGetCutoutSize(final Activity activity) {
        View decorView = activity.getWindow().getDecorView();
        decorView.requestApplyInsets();
        decorView.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

            public WindowInsets onApplyWindowInsets(View view, WindowInsets windowInsets) {
                BuoyCutoutHelper.this.handleGetCutoutSize(view, windowInsets);
                BuoyCutoutHelper.this.doFinish(activity);
                return windowInsets;
            }
        });
    }

    private void handleGetCutoutSize(View view, WindowInsets windowInsets) {
        if (view == null) {
            return;
        }
        int height = this.getCutoutHeightGoogleApi(view.getContext(), windowInsets);
        Context context = view.getContext();
        if (height == 0) {
            this.handleGetCutoutSizeHwApi(context);
        } else {
            this.handleGetCutoutSizeGoogleApi(windowInsets, context, height);
        }
    }

    private void handleGetCutoutSizeHwApi(Context context) {
        int height = this.getCutoutHeightHwApi(context);
        Rect rect = this.getCutoutRectHwApi(context);
        CutoutInfo portCutoutInfo = new CutoutInfo(height, 1, rect);
        this.cutoutInfoMap.put(1, portCutoutInfo);
        Rect landRect = new Rect();
        landRect.set(rect.top, rect.left, rect.bottom, rect.right);
        CutoutInfo landCutoutInfo = new CutoutInfo(height, 2, landRect);
        this.cutoutInfoMap.put(2, landCutoutInfo);
        BuoyLog.i(TAG, "portCutoutInfo:" + portCutoutInfo.toJson());
        BuoyStorage.getInstance().saveCutoutParams(context, this.cutoutInfoMap);
    }

    private void handleGetCutoutSizeGoogleApi(WindowInsets windowInsets, Context context, int height) {
        Rect rect = this.getCutoutRectGoogleApi(windowInsets);
        if (context.getResources().getConfiguration().orientation == 2) {
            int orientation = 2;
            CutoutInfo landCutoutInfo = new CutoutInfo(height, orientation, rect);
            this.cutoutInfoMap.put(orientation, landCutoutInfo);
            BuoyLog.i(TAG, "landCutoutInfo:" + landCutoutInfo.toJson());
            orientation = 1;
            Rect portRect = new Rect();
            portRect.set(rect.top, rect.left, rect.bottom, rect.right);
            CutoutInfo portCutoutInfo = new CutoutInfo(height, orientation, portRect);
            this.cutoutInfoMap.put(orientation, portCutoutInfo);
            BuoyLog.i(TAG, "portCutoutInfo:" + portCutoutInfo.toJson());
            BuoyStorage.getInstance().saveCutoutParams(context, this.cutoutInfoMap);
        } else if (context.getResources().getConfiguration().orientation == 1) {
            int orientation = 1;
            CutoutInfo portCutoutInfo = new CutoutInfo(height, orientation, rect);
            this.cutoutInfoMap.put(orientation, portCutoutInfo);
            BuoyLog.i(TAG, "portCutoutInfo:" + portCutoutInfo.toJson());
            orientation = 2;
            Rect landRect = new Rect();
            landRect.set(rect.top, rect.left, rect.bottom, rect.right);
            CutoutInfo landCutoutInfo = new CutoutInfo(height, orientation, landRect);
            this.cutoutInfoMap.put(orientation, landCutoutInfo);
            BuoyLog.i(TAG, "landCutoutInfo:" + landCutoutInfo.toJson());
            BuoyStorage.getInstance().saveCutoutParams(context, this.cutoutInfoMap);
        }
    }

    private static int[] getCutoutSizeHwApi(Context context) {
        int[] size = new int[]{0, 0};
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("getNotchSize", new Class[0]);
            size = (int[])get.invoke(HwNotchSizeUtil, new Object[0]);
        }
        catch (Exception e2) {
            Log.e((String)"test", (String)"getCutoutSizeHwApi meet exception");
        }
        return size;
    }

    private int getCutoutHeightHwApi(Context context) {
        return BuoyCutoutHelper.getCutoutSizeHwApi(context)[1];
    }

    private Rect getCutoutRectHwApi(Context context) {
        int[] size = BuoyCutoutHelper.getCutoutSizeHwApi(context);
        Rect rect = new Rect();
        if (context.getResources().getConfiguration().orientation == 1) {
            int screenW = WindowUtil.getScreenW(context);
            rect.left = (screenW - size[0]) / 2;
            rect.right = (screenW + size[0]) / 2;
        } else {
            int screenH = WindowUtil.getScreenH(context);
            rect.left = (screenH - size[0]) / 2;
            rect.right = (screenH + size[0]) / 2;
        }
        rect.bottom = size[1];
        rect.top = 0;
        return rect;
    }

    private int getCutoutHeightGoogleApi(Context context, WindowInsets windowInsets) {
        int height = 0;
        if (context == null) {
            BuoyLog.i(TAG, "getCutoutHeightGoogleApi context is null");
            return height;
        }
        int orientation = context.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            height = this.getSafeInsetLeft(windowInsets);
            if (height == 0) {
                height = this.getSafeInsetRight(windowInsets);
            }
            return height;
        }
        if (orientation == 1) {
            height = this.getSafeInsetTop(windowInsets);
            if (height == 0) {
                height = this.getSafeInsetBottom(windowInsets);
            }
            return height;
        }
        return height;
    }

    private Rect getCutoutRectGoogleApi(WindowInsets insets) {
        List rects;
        Object rect;
        Object object = this.invokeMethod(insets, "getBoundingRects");
        if (object instanceof List && (rect = (rects = (List)object).get(0)) instanceof Rect) {
            return (Rect)rect;
        }
        return new Rect();
    }

    private int getSafeInsetDistance(WindowInsets insets, String method) {
        Object height = this.invokeMethod(insets, method);
        if (height instanceof Integer) {
            return (Integer)height;
        }
        return 0;
    }

    private int getSafeInsetLeft(WindowInsets insets) {
        return this.getSafeInsetDistance(insets, "getSafeInsetLeft");
    }

    private int getSafeInsetRight(WindowInsets insets) {
        return this.getSafeInsetDistance(insets, "getSafeInsetRight");
    }

    private int getSafeInsetTop(WindowInsets insets) {
        return this.getSafeInsetDistance(insets, "getSafeInsetTop");
    }

    private int getSafeInsetBottom(WindowInsets insets) {
        return this.getSafeInsetDistance(insets, "getSafeInsetBottom");
    }

    private Object invokeMethod(WindowInsets insets, String method) {
        try {
            Class<?> classDisplayCutout = Class.forName("android.view.DisplayCutout");
            Method getDisplayCutout = insets.getClass().getDeclaredMethod("getDisplayCutout", new Class[0]);
            Object displayCutout = getDisplayCutout.invoke((Object)insets, new Object[0]);
            Method getSafeInsetDistance = classDisplayCutout.getDeclaredMethod(method, new Class[0]);
            return getSafeInsetDistance.invoke(displayCutout, new Object[0]);
        }
        catch (Exception e2) {
            BuoyLog.w(TAG, "getSafeInsetDistance failed, method = " + method);
            return new Object();
        }
    }

    public void setLayoutInDisplayCutoutMode(WindowManager.LayoutParams layoutParams) {
        try {
            Field layoutInDisplayCutoutMode = layoutParams.getClass().getDeclaredField("layoutInDisplayCutoutMode");
            layoutInDisplayCutoutMode.setInt(layoutParams, 1);
        }
        catch (Exception e2) {
            BuoyLog.w(TAG, "setLayoutMode error");
        }
    }

    public void setLayoutInDisplayCutoutMode(Activity activity) {
        if (Build.VERSION.SDK_INT <= 26 || !this.hasSetOpenNotch((Context)activity)) {
            BuoyLog.i(TAG, "not need setLayoutInDisplayCutoutMode");
            return;
        }
        WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
        this.setLayoutInDisplayCutoutMode(lp);
    }

    public boolean hasSetOpenNotch(Context context) {
        int value = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)DISPLAY_NOTCH_STATUS, (int)0);
        return value != 1;
    }

    public boolean hasNotchInScreen(Context context) {
        if (!this.hasSetOpenNotch(context)) {
            return false;
        }
        CutoutInfo cutoutInfo = this.getCutoutInfo(context);
        if (cutoutInfo == null) {
            return false;
        }
        return cutoutInfo.getHeight() != 0;
    }

    public CutoutInfo getCutoutInfo(Context context) {
        if (context == null) {
            return null;
        }
        if (this.cutoutInfoMap == null || this.cutoutInfoMap.isEmpty()) {
            this.cutoutInfoMap = BuoyCutoutHelper.getCutoutInfoFromSP(context);
        }
        int orientation = context.getResources().getConfiguration().orientation;
        return this.cutoutInfoMap.get(orientation);
    }

    private static Map<Integer, CutoutInfo> getCutoutInfoFromSP(Context context) {
        return BuoyStorage.getInstance().getCutoutParams(context);
    }

    public int getCutoutHeight(Context context) {
        CutoutInfo cutoutInfo = this.getCutoutInfo(context);
        if (cutoutInfo != null) {
            return cutoutInfo.getHeight();
        }
        return 0;
    }

    public boolean isCutoutPortScreen(Context context) {
        if (context == null) {
            return false;
        }
        if (context.getResources().getConfiguration().orientation != 1) {
            return false;
        }
        return this.hasNotchInScreen(context);
    }

    public boolean isAdaptNotchArea(Context context, String packageName) {
        if (context instanceof Activity) {
            return this.isActivityUseNotchArea((Activity)context);
        }
        return this.isAppUseNotchArea(context, packageName);
    }

    public boolean isActivityUseNotchArea(Activity activity) {
        if (activity == null) {
            return false;
        }
        boolean result = false;
        WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
        try {
            Field layoutInDisplayCutoutMode = attrs.getClass().getDeclaredField("layoutInDisplayCutoutMode");
            boolean bl = result = layoutInDisplayCutoutMode.getInt(attrs) == 1;
            if (result) {
                int mode = this.getAppUseNotchMode(activity.getPackageName());
                if (mode == 2) {
                    BuoyLog.i(TAG, "Activity Adapt Notch Area, but App mode = " + mode);
                    return false;
                }
            } else {
                BuoyLog.i(TAG, "Activity not adapt notch area by set layoutInDisplayCutoutMode");
                result = this.isAppUseNotchArea((Context)activity, activity.getPackageName());
            }
        }
        catch (Exception e2) {
            BuoyLog.i(TAG, "get layoutInDisplayCutoutMode meet exception");
        }
        return result;
    }

    public boolean isAppUseNotchArea(Context context, String packageName) {
        if (context == null) {
            return false;
        }
        int useNotchMode = this.getAppUseNotchMode(packageName);
        if (useNotchMode == 1) {
            BuoyLog.w(TAG, "set app:" + packageName + " show notch area by setting");
            return true;
        }
        if (useNotchMode == 2) {
            BuoyLog.w(TAG, "set app:" + packageName + " hide notch area by setting");
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 128);
            Bundle metaData = appInfo.metaData;
            if (metaData != null) {
                return metaData.getBoolean("android.notch_support");
            }
        }
        catch (Exception e2) {
            BuoyLog.e(TAG, "get android.notch_support data error:");
        }
        return false;
    }

    public int getAppUseNotchMode(String packageName) {
        int useNotchMode = 0;
        try {
            Class<?> classDisplayCutout = Class.forName("com.huawei.android.app.PackageManagerEx");
            Method method = classDisplayCutout.getDeclaredMethod("getAppUseNotchMode", String.class);
            useNotchMode = (Integer)method.invoke(classDisplayCutout, packageName);
        }
        catch (NoSuchMethodException e2) {
            BuoyLog.e(TAG, " PackageManagerEx.getAppUseNotchMode meet NoSuchMethodException");
        }
        catch (IllegalAccessException e3) {
            BuoyLog.e(TAG, " PackageManagerEx.getAppUseNotchMode meet IllegalAccessException");
        }
        catch (InvocationTargetException e4) {
            BuoyLog.e(TAG, " PackageManagerEx.getAppUseNotchMode meet InvocationTargetException");
        }
        catch (ClassNotFoundException e5) {
            BuoyLog.e(TAG, " PackageManagerEx.getAppUseNotchMode meet ClassNotFoundException");
        }
        return useNotchMode;
    }
}

