/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.manager;

import android.content.Context;
import com.huawei.appmarket.component.buoycircle.api.AppInfo;
import com.huawei.appmarket.component.buoycircle.api.IBuoyBIHandler;
import com.huawei.appmarket.component.buoycircle.api.IBuoyCircleControl;
import com.huawei.appmarket.component.buoycircle.api.ISwitchGameAccountCallBack;
import com.huawei.appmarket.component.buoycircle.impl.bi.BuoyAnalyticHelper;
import com.huawei.appmarket.component.buoycircle.impl.manager.BuoyHideCacheManager;
import com.huawei.appmarket.component.buoycircle.impl.manager.FloatWindowManager;
import com.huawei.hmf.annotation.ApiDefine;
import com.huawei.hmf.annotation.Singleton;

@Singleton
@ApiDefine(uri=IBuoyCircleControl.class)
public class BuoyCircleManager
implements IBuoyCircleControl {
    private static BuoyCircleManager instance;

    public static synchronized BuoyCircleManager getInstance() {
        if (instance == null) {
            instance = new BuoyCircleManager();
        }
        return instance;
    }

    @Override
    public void createBuoyCircle(Context context, AppInfo appInfo) {
        FloatWindowManager.getInstance().createSmallWindow(context, appInfo, 0);
    }

    @Override
    public void createBuoyCircle(Context context, AppInfo appInfo, int createMode) {
        FloatWindowManager.getInstance().createSmallWindow(context, appInfo, createMode);
    }

    @Override
    public void setBuoyBIHandler(IBuoyBIHandler buoyBIHandler) {
        BuoyAnalyticHelper.getInstance().init(buoyBIHandler);
    }

    @Override
    public void setSwitchGameAccountCallBack(ISwitchGameAccountCallBack callback) {
        FloatWindowManager.getInstance().setSwitchGameAccountCallBack(callback);
    }

    @Override
    public void removeBuoyCircle() {
        FloatWindowManager.getInstance().removeSmallWindow();
    }

    @Override
    public void performDestroy() {
        FloatWindowManager.getInstance().performDestroy();
    }

    @Override
    public int getBuoyHideMode(Context context, String appId, String packageName) {
        return BuoyHideCacheManager.getInstance().getBuoyHideMode(context, appId, packageName);
    }
}

