/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.remote;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.TextUtils;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.remote.ExternalViewManager;
import com.huawei.appmarket.component.buoycircle.impl.remote.RemoteApiManager;
import com.huawei.appmarket.component.buoycircle.impl.remote.RunTask;
import com.huawei.appmarket.component.buoycircle.impl.utils.PackageManagerHelper;
import com.huawei.gamebox.plugin.gameservice.service.ICallback;
import com.huawei.gamebox.plugin.gameservice.service.IGameBuoyService;
import com.huawei.gamebox.plugin.gameservice.service.RequestInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class BuoyServiceApiClient {
    private static final String TAG = "BuoyServiceApiClient";
    private static final int DELAY_START_SERVICE = 300;
    private static final int MSG_CONN_TIMEOUT = 2;
    private String targetApp;
    private String showBuoyApp;
    private Map<String, GameServiceApiHandler> mReqHandlerTasks;
    private List<GameServiceApiHandler> mInitHandlerList;
    private Handler mConnectTimeoutHandler = null;
    private static volatile BuoyServiceApiClient instance = new BuoyServiceApiClient();
    private IGameBuoyService remoteService = null;
    private WeakReference<Context> mContext;
    private boolean mNeedRetryAidl = false;
    private int isBind = 0;
    private ICallback mCallBack = new ICallback.Stub(){

        @Override
        public void onInit(int result) throws RemoteException {
            BuoyLog.d(BuoyServiceApiClient.TAG, "onInit:" + result);
        }

        @Override
        public void response(String reqId, String resp) throws RemoteException {
            BuoyLog.i(BuoyServiceApiClient.TAG, "response:" + reqId);
            BuoyLog.d(BuoyServiceApiClient.TAG, "method:" + reqId + ", response:" + resp);
            if (BuoyServiceApiClient.this.isBind != 2) {
                BuoyLog.e(BuoyServiceApiClient.TAG, "response not bind, method:" + reqId);
            }
            try {
                if (TextUtils.isEmpty((CharSequence)reqId)) {
                    return;
                }
                GameServiceApiHandler handler = (GameServiceApiHandler)BuoyServiceApiClient.this.mReqHandlerTasks.get(reqId);
                if (handler != null) {
                    handler.onResult(0, resp);
                }
            }
            catch (Exception e2) {
                BuoyLog.e(BuoyServiceApiClient.TAG, "handle the response meet exception");
            }
        }

        @Override
        public void openView(String taskId) throws RemoteException {
            BuoyLog.i(BuoyServiceApiClient.TAG, "openView:" + taskId);
            if (BuoyServiceApiClient.this.mContext == null) {
                BuoyLog.e(BuoyServiceApiClient.TAG, "mContext is null");
                return;
            }
            if (!PackageManagerHelper.isBackground((Context)BuoyServiceApiClient.this.mContext.get(), BuoyServiceApiClient.this.getShowBuoyApp())) {
                BuoyLog.i(BuoyServiceApiClient.TAG, "remote open the view:" + taskId);
                ExternalViewManager proxy = new ExternalViewManager((Context)BuoyServiceApiClient.this.mContext.get());
                proxy.openExternalView(taskId);
            }
            if (BuoyServiceApiClient.this.mContext.get() != null && BuoyServiceApiClient.this.mContext.get() instanceof Activity) {
                Activity activity = (Activity)BuoyServiceApiClient.this.mContext.get();
                final RunTask task = RemoteApiManager.getInstance().getRemoveSmallBuoyTask();
                if (task != null) {
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            task.run();
                        }
                    });
                }
            }
        }
    };
    private ServiceConnection serverConnection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            BuoyLog.i(BuoyServiceApiClient.TAG, "onServiceDisconnected()...");
            BuoyServiceApiClient.this.remoteService = null;
            BuoyServiceApiClient.this.isBind = 0;
            RunTask task = RemoteApiManager.getInstance().getOnServiceDisconnectTask();
            if (task != null) {
                task.run();
            }
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            BuoyLog.i(BuoyServiceApiClient.TAG, "onServiceConnected()...");
            BuoyServiceApiClient.this.cancelConnDelayHandle();
            BuoyServiceApiClient.this.remoteService = IGameBuoyService.Stub.asInterface(service);
            if (BuoyServiceApiClient.this.remoteService == null) {
                BuoyLog.e(BuoyServiceApiClient.TAG, "create the remoteService failed");
                BuoyServiceApiClient.this.notifyInitResult(2);
                return;
            }
            BuoyServiceApiClient.this.isBind = 2;
            BuoyServiceApiClient.this.notifyInitResult(0);
        }
    };

    public static BuoyServiceApiClient getInstance() {
        return instance;
    }

    private BuoyServiceApiClient() {
        this.mReqHandlerTasks = new HashMap<String, GameServiceApiHandler>();
        this.mInitHandlerList = new ArrayList<GameServiceApiHandler>();
    }

    public void init(Context context, boolean needRetryAidl, GameServiceApiHandler handler) {
        BuoyLog.d(TAG, "start to init the service:" + context);
        if (context == null) {
            BuoyLog.e(TAG, "param context is null");
            return;
        }
        if (handler == null) {
            BuoyLog.e(TAG, "param handler is null");
            return;
        }
        this.mContext = new WeakReference<Context>(context);
        if (this.remoteService != null) {
            BuoyLog.d(TAG, "remote service is binded");
            handler.onResult(0, null);
            return;
        }
        this.mInitHandlerList.add(handler);
        if (this.isBind == 1) {
            BuoyLog.d(TAG, "the remote service is binding");
            return;
        }
        this.mNeedRetryAidl = needRetryAidl;
        BuoyLog.d(TAG, "start to bind service.");
        this.bindService();
    }

    public void request(RequestInfo resuestInfo, GameServiceApiHandler handler) {
        if (this.remoteService == null) {
            BuoyLog.e(TAG, "remote service is not binded");
            handler.onResult(2, null);
            return;
        }
        try {
            BuoyLog.i(TAG, "request:" + resuestInfo.getMethod());
            BuoyLog.d(TAG, "request info:" + resuestInfo.toString());
            this.mReqHandlerTasks.put(resuestInfo.getMethod(), handler);
            this.remoteService.request(resuestInfo, this.mCallBack);
        }
        catch (RemoteException e2) {
            BuoyLog.e(TAG, "call remoteService.request meet exception");
            handler.onResult(2, null);
            this.remoteService = null;
        }
    }

    public void registerHandler(String method, GameServiceApiHandler handler) {
        this.mReqHandlerTasks.put(method, handler);
    }

    public Context getContext() {
        return (Context)this.mContext.get();
    }

    public void terminate() {
        if (this.mContext == null) {
            BuoyLog.e(TAG, "mContext is null");
            return;
        }
        Context context = (Context)this.mContext.get();
        BuoyLog.d(TAG, "call unbind service:" + context);
        if (context == null) {
            BuoyLog.e(TAG, "mContext is null, terminate failed");
            this.remoteService = null;
            this.isBind = 0;
            return;
        }
        this.cancelConnDelayHandle();
        if (this.serverConnection == null) {
            BuoyLog.e(TAG, "serverConnection is null");
        }
        try {
            context.getApplicationContext().unbindService(this.serverConnection);
        }
        catch (Exception e2) {
            BuoyLog.e(TAG, "unbind service meet exception");
        }
        this.remoteService = null;
        this.isBind = 0;
    }

    private void bindService() {
        this.isBind = 1;
        BuoyLog.i(TAG, "start to bind service");
        Context context = (Context)this.mContext.get();
        if (context != null) {
            Intent serviceIntent = new Intent("com.huawei.gamebox.GAME_BUOY_SERVICE");
            serviceIntent.setPackage(this.getTargetApp());
            boolean result = context.getApplicationContext().bindService(serviceIntent, this.serverConnection, 1);
            if (!result) {
                BuoyLog.e(TAG, "bindService result is false!");
                this.isBind = 0;
                if (this.mNeedRetryAidl) {
                    this.retryAidl();
                } else {
                    this.notifyInitResult(10);
                }
            } else {
                this.postConnDelayHandle();
            }
        } else {
            BuoyLog.e(TAG, "bindService fail for context is null!");
        }
    }

    private void notifyInitResult(int result) {
        for (GameServiceApiHandler handler : this.mInitHandlerList) {
            if (handler == null) continue;
            handler.onResult(result, null);
        }
        this.mInitHandlerList.clear();
    }

    private void postConnDelayHandle() {
        if (this.mConnectTimeoutHandler != null) {
            this.mConnectTimeoutHandler.removeMessages(2);
        } else {
            this.mConnectTimeoutHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    if (msg == null || msg.what != 2) {
                        return false;
                    }
                    BuoyServiceApiClient.this.terminate();
                    BuoyLog.e(BuoyServiceApiClient.TAG, "In connect buoy service, bind service time out");
                    if (BuoyServiceApiClient.this.isBind == 1) {
                        BuoyServiceApiClient.this.isBind = 0;
                        if (BuoyServiceApiClient.this.mNeedRetryAidl) {
                            BuoyServiceApiClient.this.retryAidl();
                        } else {
                            BuoyServiceApiClient.this.notifyInitResult(10);
                        }
                    }
                    return true;
                }
            });
        }
        this.mConnectTimeoutHandler.sendEmptyMessageDelayed(2, 3000L);
    }

    private void retryAidl() {
        this.mNeedRetryAidl = false;
        Context context = (Context)this.mContext.get();
        if (context != null) {
            try {
                Intent openGameBox = new Intent("com.huawei.gamebox.transferactivity");
                openGameBox.setPackage(this.getTargetApp());
                if (!(context instanceof Activity)) {
                    openGameBox.setFlags(0x10000000);
                }
                context.startActivity(openGameBox);
            }
            catch (Exception e2) {
                BuoyLog.e(TAG, "start transfer activity meet exception");
            }
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    BuoyServiceApiClient.this.bindService();
                }
            };
            Timer timer = new Timer();
            timer.schedule(task, 300L);
        } else {
            BuoyLog.e(TAG, "retryAidl fail for context is null!");
        }
    }

    private void cancelConnDelayHandle() {
        if (this.mConnectTimeoutHandler != null) {
            this.mConnectTimeoutHandler.removeMessages(2);
            this.mConnectTimeoutHandler = null;
        }
    }

    public String getTargetApp() {
        if (TextUtils.isEmpty((CharSequence)this.targetApp)) {
            return "com.huawei.appmarket";
        }
        return this.targetApp;
    }

    public void setTargetApp(String targetApp) {
        this.targetApp = targetApp;
    }

    public void setShowBuoyApp(String showBuoyApp) {
        this.showBuoyApp = showBuoyApp;
    }

    public String getShowBuoyApp() {
        return this.showBuoyApp;
    }

    private static interface BIND_STATUS {
        public static final int NOT_BIND = 0;
        public static final int BINDING = 1;
        public static final int BOUND = 2;
    }

    public static interface GameServiceApiHandler {
        public void onResult(int var1, String var2);
    }
}

