/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.security;

public final class Base64 {
    private static final char[] ENCODE_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    private Base64() {
    }

    public static String encode(byte[] data) {
        return Base64.encode(data, data.length);
    }

    public static String encode(byte[] data, int length) {
        int outlen = (length + 2) / 3 * 4;
        char[] ret = new char[outlen];
        int i2 = 0;
        int index = 0;
        while (i2 < length) {
            boolean padding1 = false;
            boolean padding2 = false;
            int val = 0xFF & data[i2];
            val <<= 8;
            if (i2 + 1 < length) {
                val |= 0xFF & data[i2 + 1];
                padding2 = true;
            }
            val <<= 8;
            if (i2 + 2 < length) {
                val |= 0xFF & data[i2 + 2];
                padding1 = true;
            }
            ret[index + 3] = ENCODE_TABLE[padding1 ? val & 0x3F : 64];
            ret[index + 2] = ENCODE_TABLE[padding2 ? (val >>= 6) & 0x3F : 64];
            ret[index + 1] = ENCODE_TABLE[(val >>= 6) & 0x3F];
            ret[index + 0] = ENCODE_TABLE[(val >>= 6) & 0x3F];
            i2 += 3;
            index += 4;
        }
        return new String(ret);
    }

    public static byte[] decode(String str) {
        int tempLen = Base64.vaildLen(str);
        int len = tempLen / 4 * 3;
        if (tempLen % 4 == 3) {
            len += 2;
        }
        if (tempLen % 4 == 2) {
            ++len;
        }
        byte[] ret = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            int value;
            char ch = str.charAt(i2);
            int n2 = value = ch > '\u00ff' ? -1 : DECODE_TABLE[ch];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            ret[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        if (index != ret.length) {
            return new byte[0];
        }
        return ret;
    }

    private static int vaildLen(String str) {
        int len = str.length();
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char ch = str.charAt(i2);
            if (ch <= '\u00ff' && DECODE_TABLE[ch] >= 0) continue;
            --len;
        }
        return len;
    }
}

