/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.security;

import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class SHA256 {
    private static final String TAG = "SHA256";
    private static final int BUFF_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] digest(File file) {
        InputStream in = null;
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] buff = new byte[4096];
            int count = 0;
            while ((len = in.read(buff)) != -1) {
                count += len;
                md.update(buff, 0, len);
            }
            if (count > 0) {
                byte[] byArray = md.digest();
                return byArray;
            }
        }
        catch (IOException | NoSuchAlgorithmException e2) {
            BuoyLog.e(TAG, "An exception occurred while computing file 'SHA-256'.");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e3) {
                    BuoyLog.e(TAG, "An exception occurred while closing the 'Closeable' object.");
                }
            }
        }
        return new byte[0];
    }
}

