/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.storage;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.appmarket.component.buoycircle.impl.cutout.CutoutInfo;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.security.Base64;
import com.huawei.appmarket.component.buoycircle.impl.storage.GamePreferences;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class BuoyStorage {
    private static final String TAG = "BuoyStorage";
    private static final String ENCODING_UTF8 = "UTF-8";
    private static BuoyStorage instance = new BuoyStorage();
    private static final String HMS_GAME_SP_PLAYERID = "hms.game.sp.playerId";
    private static final String HMS_GAME_SP_BUOY_HIDE_GUIDE = "hms.game.sp.buoy.hide.guide";
    private static final String FILE_NAME_LOGIN = "hms.game.login.info";
    private static final String FILE_NAME_BUOY = "hms.game.buoy.info";
    private static final String CUTOUT_KEY_PREFIX = "cutout_";

    public static BuoyStorage getInstance() {
        return instance;
    }

    private void putSecretString(Context context, String key, String value) {
        try {
            String formatedValue = Base64.encode(value.getBytes(ENCODING_UTF8));
            GamePreferences mPreferenses = new GamePreferences(context, FILE_NAME_LOGIN);
            mPreferenses.saveString(key, formatedValue);
        }
        catch (Exception e2) {
            BuoyLog.e(TAG, "putSecretString meet exception");
        }
    }

    private String getSecretString(Context context, String key) {
        String value = null;
        try {
            String tmpValue;
            GamePreferences mPreferenses = new GamePreferences(context, FILE_NAME_LOGIN);
            value = mPreferenses.getString(key);
            if (TextUtils.isEmpty((CharSequence)value)) {
                return value;
            }
            value = tmpValue = new String(Base64.decode(value), ENCODING_UTF8);
        }
        catch (Exception e2) {
            BuoyLog.e(TAG, "getSecretString meet exception");
        }
        return value;
    }

    public void savePlayerId(Context context, String playerId) {
        this.putSecretString(context, HMS_GAME_SP_PLAYERID, playerId);
    }

    public void saveHideGuideRecord(Context context) {
        this.putSecretString(context, HMS_GAME_SP_BUOY_HIDE_GUIDE, "nomind");
    }

    public String getHideGuideRecord(Context context) {
        return this.getSecretString(context, HMS_GAME_SP_BUOY_HIDE_GUIDE);
    }

    public void saveCutoutParams(Context context, Map<Integer, CutoutInfo> cutoutInfoMap) {
        GamePreferences mPreferenses = new GamePreferences(context, FILE_NAME_BUOY);
        Set<Integer> set = cutoutInfoMap.keySet();
        for (Integer orientation : set) {
            JSONObject json = cutoutInfoMap.get(orientation).toJson();
            if (json == null) continue;
            mPreferenses.saveString(CUTOUT_KEY_PREFIX + orientation, json.toString());
        }
    }

    public Map<Integer, CutoutInfo> getCutoutParams(Context context) {
        if (context == null) {
            return null;
        }
        CutoutInfo portCutoutInfo = this.getOrientationCutoutInfo(1, context);
        CutoutInfo landCutoutInfo = this.getOrientationCutoutInfo(2, context);
        HashMap<Integer, CutoutInfo> cutoutInfoMap = new HashMap<Integer, CutoutInfo>();
        if (portCutoutInfo != null) {
            cutoutInfoMap.put(1, portCutoutInfo);
        }
        if (landCutoutInfo != null) {
            cutoutInfoMap.put(2, landCutoutInfo);
        }
        return cutoutInfoMap;
    }

    public CutoutInfo getOrientationCutoutInfo(int orientation, Context context) {
        GamePreferences mPreferenses = new GamePreferences(context, FILE_NAME_BUOY);
        String portJson = mPreferenses.getString(CUTOUT_KEY_PREFIX + orientation);
        return CutoutInfo.fromJson(portJson);
    }
}

