/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.storage;

import android.content.Context;
import android.content.SharedPreferences;

public class SharedInfoService {
    private SharedPreferences mPreferences;
    private static SharedInfoService util;

    public static synchronized SharedInfoService getInstance(Context context) {
        if (util == null) {
            util = new SharedInfoService(context);
        }
        return util;
    }

    private SharedInfoService(Context context) {
        this.mPreferences = context.getSharedPreferences("DeviceSession", 0);
    }

    public float getPositionYPercent() {
        return this.mPreferences.getFloat("buoy.positionypercent.key.param", -1.0f);
    }

    public float getPositionXPercent() {
        return this.mPreferences.getFloat("buoy.positionxpercent.key.param", -1.0f);
    }

    public void setPositionYPercent(float positionYPercent) {
        SharedPreferences.Editor editor = this.mPreferences.edit();
        editor.putFloat("buoy.positionypercent.key.param", positionYPercent).commit();
    }

    public void setPositionXPercent(float positionXPercent) {
        SharedPreferences.Editor editor = this.mPreferences.edit();
        editor.putFloat("buoy.positionxpercent.key.param", positionXPercent).commit();
    }

    public static interface SharedKeys {
        public static final String POSITION_Y_PERCENT_KEY_PARAM = "buoy.positionypercent.key.param";
        public static final String POSITION_X_PERCENT_KEY_PARAM = "buoy.positionxpercent.key.param";
    }
}

