/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.download;

import android.content.Context;
import android.content.SharedPreferences;

class DownloadRecord {
    private static final String SP_NAME = "com.huawei.hms.update.DOWNLOAD_RECORD";
    private String mUri;
    private int mSize;
    private String mHash;
    private int mReceived;

    DownloadRecord() {
    }

    public void load(Context context, String packageName) {
        SharedPreferences sp = context.getSharedPreferences(SP_NAME + packageName, 0);
        this.mUri = sp.getString("mUri", "");
        this.mSize = sp.getInt("mSize", 0);
        this.mHash = sp.getString("mHash", "");
        this.mReceived = sp.getInt("mReceived", 0);
    }

    public void init(String uri, int size, String hash) {
        this.mUri = uri;
        this.mSize = size;
        this.mHash = hash;
        this.mReceived = 0;
    }

    public void update(Context context, int received, String packageName) {
        this.mReceived = received;
        this.save(context, packageName);
    }

    private void save(Context context, String packageName) {
        SharedPreferences sp = context.getSharedPreferences(SP_NAME + packageName, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("mUri", this.mUri);
        editor.putInt("mSize", this.mSize);
        editor.putString("mHash", this.mHash);
        editor.putInt("mReceived", this.mReceived);
        editor.commit();
    }

    public int getSize() {
        return this.mSize;
    }

    int getReceived() {
        return this.mReceived;
    }

    public boolean isValid(String uri, int size, String hash) {
        return uri != null && hash != null && this.mUri != null && this.mUri.equals(uri) && this.mSize == size && this.mHash != null && this.mHash.equals(hash) && this.mReceived <= this.mSize;
    }
}

